/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.compression.GZipCompression;
import org.mule.test.AbstractIntegrationTestCase;

public class GZipTransformerFunctionalTestCase
extends AbstractIntegrationTestCase {
    private static final String TEST_DATA = "the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog";

    protected String getConfigFile() {
        return "org/mule/test/transformers/gzip-transformer-functional-test.xml";
    }

    @Test
    public void testCompressDecompressByteArray() throws Exception {
        byte[] testDataByteArray = TEST_DATA.getBytes();
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("compressInput").withPayload((Object)testDataByteArray)).run();
        Message compressedResponse = muleEvent.getMessage();
        Assert.assertNotNull((Object)compressedResponse);
        Assert.assertTrue((boolean)(compressedResponse.getPayload().getValue() instanceof byte[]));
        muleEvent = ((FlowRunner)this.flowRunner("decompressInput").withPayload(compressedResponse.getPayload().getValue())).run();
        Message uncompressedResponse = muleEvent.getMessage();
        Assert.assertNotNull((Object)uncompressedResponse);
        Assert.assertTrue((boolean)(uncompressedResponse.getPayload().getValue() instanceof byte[]));
        String uncompressedStr = new String((byte[])uncompressedResponse.getPayload().getValue());
        Assert.assertEquals((Object)TEST_DATA, (Object)uncompressedStr);
    }

    @Test
    public void testCompressDecompressInputStream() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(TEST_DATA.getBytes());
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("compressInput").withPayload((Object)bis)).run();
        Message compressedResponse = muleEvent.getMessage();
        Assert.assertNotNull((Object)compressedResponse);
        Assert.assertTrue((boolean)(compressedResponse.getPayload().getValue() instanceof InputStream));
        muleEvent = ((FlowRunner)this.flowRunner("decompressInput").withPayload(compressedResponse.getPayload().getValue())).run();
        Message uncompressedResponse = muleEvent.getMessage();
        Assert.assertNotNull((Object)uncompressedResponse);
        Assert.assertTrue((boolean)(uncompressedResponse.getPayload().getValue() instanceof InputStream));
        byte[] uncompressedByteArray = IOUtils.toByteArray((InputStream)((InputStream)uncompressedResponse.getPayload().getValue()));
        String uncompressedStr = new String(uncompressedByteArray);
        Assert.assertEquals((Object)TEST_DATA, (Object)uncompressedStr);
    }

    @Test
    public void testCompressDecompressString() throws Exception {
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("compressInput").withPayload((Object)TEST_DATA)).run();
        Message compressedResponse = muleEvent.getMessage();
        Assert.assertNotNull((Object)compressedResponse);
        Assert.assertTrue((boolean)(compressedResponse.getPayload().getValue() instanceof byte[]));
        byte[] bytes = new GZipCompression().uncompressByteArray((byte[])compressedResponse.getPayload().getValue());
        String clientUncompressed = new String(bytes, "UTF8");
        Assert.assertEquals((Object)TEST_DATA, (Object)clientUncompressed);
        muleEvent = ((FlowRunner)this.flowRunner("decompressInputString").withPayload(compressedResponse.getPayload().getValue())).run();
        Message uncompressedResponse = muleEvent.getMessage();
        Assert.assertNotNull((Object)uncompressedResponse);
        Assert.assertTrue((boolean)(uncompressedResponse.getPayload().getValue() instanceof String));
        Assert.assertEquals((Object)TEST_DATA, (Object)uncompressedResponse.getPayload().getValue());
    }
}

