/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.test.AbstractIntegrationTestCase;

public class ImplicitTransformationTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/transformers/implicit-transformation-config.xml";
    }

    @Test
    public void testImplicitInputStreamToStringConversion() throws Exception {
        StringInputStream inputStream = new StringInputStream("TEST");
        Message response = ((FlowRunner)this.flowRunner("StringEchoService").withPayload((Object)inputStream)).run().getMessage();
        Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"TSET"));
    }

    @Test
    public void testImplicitByteArrayToStringConversion() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("StringEchoService").withPayload((Object)"TEST".getBytes())).run().getMessage();
        Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"TSET"));
    }

    @Test
    public void testImplicitInputStreamToByteArrayConversion() throws Exception {
        StringInputStream inputStream = new StringInputStream("TEST");
        Message response = ((FlowRunner)this.flowRunner("ByteArrayEchoService").withPayload((Object)inputStream)).run().getMessage();
        Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"TSET"));
    }

    @Test
    public void testImplicitStringToByteArrayConversion() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("ByteArrayEchoService").withPayload((Object)"TEST")).run().getMessage();
        Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"TSET"));
    }

    @Test
    public void testImplicitStringToInputStreamConversion() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("InputStreamEchoService").withPayload((Object)"TEST")).run().getMessage();
        Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"TSET"));
    }

    @Test
    public void testImplicitByteArrayToInputStreamConversion() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("InputStreamEchoService").withPayload((Object)"TEST".getBytes())).run().getMessage();
        Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"TSET"));
    }

    public static class TestInputStreamTransformer
    extends AbstractTransformer {
        public TestInputStreamTransformer() {
            this.registerSourceType(DataType.INPUT_STREAM);
            this.setReturnDataType(DataType.STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doTransform(Object src, Charset enc) throws TransformerException {
            String stringValue;
            InputStream input = (InputStream)src;
            try {
                stringValue = IOUtils.toString((InputStream)input);
            }
            finally {
                IOUtils.closeQuietly((Closeable)input);
            }
            return StringUtils.reverse((String)stringValue);
        }
    }

    public static class TestByteArrayTransformer
    extends AbstractTransformer {
        public TestByteArrayTransformer() {
            this.registerSourceType(DataType.BYTE_ARRAY);
            this.setReturnDataType(DataType.STRING);
        }

        protected Object doTransform(Object src, Charset enc) throws TransformerException {
            return StringUtils.reverse((String)new String((byte[])src));
        }
    }

    public static class TestStringTransformer
    extends AbstractTransformer {
        public TestStringTransformer() {
            this.registerSourceType(DataType.STRING);
            this.setReturnDataType(DataType.STRING);
        }

        protected Object doTransform(Object src, Charset enc) throws TransformerException {
            return StringUtils.reverse((String)((String)src));
        }
    }
}

