/*
 * Decompiled with CFR 0.152.
 */
package org.mule.http.client;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="HTTP Service")
@Issue(value="W-17370109")
public class HttpClientResponseStreamingTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    protected String getConfigFile() {
        return "http-requester-response-streaming.xml";
    }

    @Test
    public void whenClientSeesAnErrorAfterThePayloadWasCommitted_thenTheErrorIsSeenByThePayloadConsumer() throws Exception {
        TestServerThread server = new TestServerThread(this.httpPort.getNumber());
        server.start();
        MessagingException exception = (MessagingException)Assert.assertThrows(MessagingException.class, () -> this.runFlow("theFlow"));
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(ExpressionRuntimeException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Remotely closed")))));
        server.join();
    }

    private static class TestServerThread
    extends Thread {
        private final int port;

        private TestServerThread(int port) {
            this.port = port;
        }

        private Socket acceptOneConnection(int port) throws IOException {
            try (ServerSocket passiveSocket = new ServerSocket(port);){
                Socket socket = passiveSocket.accept();
                return socket;
            }
        }

        @Override
        public void run() {
            try (Socket peerSocket = this.acceptOneConnection(this.port);){
                this.readUntilDoubleLineReturn(peerSocket);
                OutputStream outputStream = peerSocket.getOutputStream();
                outputStream.write("HTTP/1.1 200 OK\nContent-Type: text/plain; charset=iso-8859-1\nTransfer-encoding: chunked\n\n1\nA\n".getBytes());
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void readUntilDoubleLineReturn(Socket peerSocket) throws IOException {
            InputStream inputStream = peerSocket.getInputStream();
            StringBuilder sb = new StringBuilder();
            boolean found = false;
            boolean endOfStream = false;
            while (!found && !endOfStream) {
                byte[] buffer = new byte[1024];
                int read = inputStream.read(buffer);
                if (read == -1) {
                    endOfStream = true;
                    continue;
                }
                sb.append(new String(buffer, 0, read));
                String current = sb.toString();
                if (!current.contains("\r\n\r\n") && !current.contains("\n\n")) continue;
                found = true;
            }
        }
    }
}

