/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Lazy Initialization")
@Story(value="Backpressure")
public class SourceBackpressureConfigLazyInitTestCase
extends AbstractIntegrationTestCase {
    @Inject
    @Named(value="_muleLazyComponentInitializer")
    private LazyComponentInitializer lazyComponentInitializer;

    protected String getConfigFile() {
        return "org/mule/test/config/source-backpressure-config.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    @Test
    @Issue(value="MULE-19117")
    public void defaultToFail() {
        Location location = Location.builder().globalName("defaultToFail").build();
        this.lazyComponentInitializer.initializeComponent(location);
    }

    @Test
    public void configuredToDrop() {
        Location location = Location.builder().globalName("configuredToDrop").build();
        this.lazyComponentInitializer.initializeComponent(location);
    }
}

