/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.functional.junit4.rules.HttpServerRule;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutableComponent;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.IntegrationTestCaseRunnerConfig;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Routers")
@Story(value="Processor Chain Router")
public class ProcessorChainRouterTestCase
extends AbstractIntegrationTestCase
implements IntegrationTestCaseRunnerConfig {
    @Inject
    @Named(value="compositeChainRouter")
    private ExecutableComponent compositeChainRouter;
    @Inject
    @Named(value="compositeChainRouterError")
    private ExecutableComponent compositeChainRouterError;
    @Inject
    @Named(value="chainRouter")
    private ExecutableComponent chainRouter;
    @Inject
    @Named(value="chainRouterError")
    private ExecutableComponent chainRouterError;
    @Inject
    @Named(value="chainRouterComponents")
    private ExecutableComponent chainRouterComponents;
    @Inject
    @Named(value="byPassFlow")
    private ExecutableComponent byPassFlow;
    @Inject
    @Named(value="flowRefCompositeChainRouter")
    private ExecutableComponent flowRefCompositeChainRouter;
    @Inject
    @Named(value="nonBlockingCompositeChainRouter")
    private ExecutableComponent nonBlockingCompositeChainRouter;
    @Inject
    @Named(value="invalidExpressionParamCompositeChainRouter")
    private ExecutableComponent invalidExpressionParamCompositeChainRouter;
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public HttpServerRule httpServerRule = new HttpServerRule("httpPort");
    private static boolean previousPropagationEnabledInTracing;
    private ExecutionResult executionResult;

    protected String getConfigFile() {
        return "org/mule/construct/processor-chain-router-config.xml";
    }

    @BeforeClass
    public static void before() {
        previousPropagationEnabledInTracing = Boolean.parseBoolean("mule.enable.propagation.of.exceptions.in.tracing");
        System.setProperty("mule.enable.propagation.of.exceptions.in.tracing", "false");
    }

    @After
    public void after() {
        if (this.executionResult != null) {
            this.executionResult.complete();
        }
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("mule.enable.propagation.of.exceptions.in.tracing", Boolean.toString(previousPropagationEnabledInTracing));
    }

    @Test
    public void executeCompositeRouterUsingInputEvent() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.compositeChainRouter.execute(event);
        this.executionResult = (ExecutionResult)completableFuture.get();
        Event returnedEvent = this.executionResult.getEvent();
        this.assertProcessorChainResult(returnedEvent);
    }

    @Test
    public void executeCompositeRouterUsingEvent() throws Exception {
        this.executionResult = (ExecutionResult)this.byPassFlow.execute(this.createInputEvent()).get();
        Event flowResultEvent = this.executionResult.getEvent();
        CompletableFuture completableFuture = this.compositeChainRouter.execute(flowResultEvent);
        Event returnedEvent = (Event)completableFuture.get();
        this.assertProcessorChainResult(returnedEvent);
    }

    @Test
    @Description(value="Ensure that when composite processor chain is used with more complex/async components such as nested flow-ref there are no dead-locks.")
    public void nestedFlowRefUsingInputEvent() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.flowRefCompositeChainRouter.execute(event);
        this.executionResult = (ExecutionResult)completableFuture.get();
        Event returnedEvent = this.executionResult.getEvent();
        this.assertProcessorChainResult(returnedEvent);
    }

    @Test
    @Description(value="Ensure that when composite processor chain is used with more complex/async components such as nested flow-ref there are no dead-locks.")
    public void nestedFlowRefUsingEvent() throws Exception {
        this.executionResult = (ExecutionResult)this.byPassFlow.execute(this.createInputEvent()).get();
        Event flowResultEvent = this.executionResult.getEvent();
        CompletableFuture completableFuture = this.flowRefCompositeChainRouter.execute(flowResultEvent);
        Event returnedEvent = (Event)completableFuture.get();
        this.assertProcessorChainResult(returnedEvent);
    }

    @Test
    public void executeCompositeRouterWithError() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.compositeChainRouterError.execute(event);
        try {
            this.executionResult = (ExecutionResult)completableFuture.get();
            this.executionResult.getEvent();
            Assert.fail();
        }
        catch (ExecutionException e) {
            ComponentExecutionException componentExecutionException = (ComponentExecutionException)e.getCause();
            Event returnedEvent = componentExecutionException.getEvent();
            MatcherAssert.assertThat((Object)returnedEvent, (Matcher)IsNull.notNullValue());
            MatcherAssert.assertThat((Object)returnedEvent.getError().isPresent(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)((Error)returnedEvent.getError().get()).getErrorType().getIdentifier(), (Matcher)Is.is((Object)"CLIENT_SECURITY"));
        }
    }

    @Test
    public void executeChainUsingInputEvent() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.chainRouter.execute(event);
        this.executionResult = (ExecutionResult)completableFuture.get();
        Event returnedEvent = this.executionResult.getEvent();
        MatcherAssert.assertThat((Object)returnedEvent, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)returnedEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"testPayload custom"));
    }

    @Test
    public void executeChainWithError() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.chainRouterError.execute(event);
        try {
            completableFuture.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            ComponentExecutionException componentExecutionException = (ComponentExecutionException)e.getCause();
            Event returnedEvent = componentExecutionException.getEvent();
            MatcherAssert.assertThat((Object)returnedEvent, (Matcher)IsNull.notNullValue());
            MatcherAssert.assertThat((Object)returnedEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"testPayload custom"));
        }
    }

    @Test
    public void executeChainFlowConstructDependantComponents() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.chainRouterComponents.execute(event);
        this.executionResult = (ExecutionResult)completableFuture.get();
        Event returnedEvent = this.executionResult.getEvent();
        MatcherAssert.assertThat((Object)returnedEvent, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)this.queueManager.read("asyncQueue", 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)this.queueManager.read("sgRoute1Queue", 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)this.queueManager.read("sgRoute2Queue", 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
    }

    @Test
    @Issue(value="MULE-18161")
    @Description(value="Ensure that app graceful shutdown timeout is not imposed as an operation timeout on MUnit chains.")
    public void nonBlockingCompositeChainRouter() throws Exception {
        this.httpServerRule.getSimpleHttpServer().setResponseDelay(6000L);
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.nonBlockingCompositeChainRouter.execute(event);
        this.executionResult = (ExecutionResult)completableFuture.get();
        MatcherAssert.assertThat((Object)this.executionResult.getEvent(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    @Issue(value="MULE-18200")
    public void invalidExpressionParamCompositeChainRouter() throws Exception {
        InputEvent event = this.createInputEvent();
        CompletableFuture completableFuture = this.invalidExpressionParamCompositeChainRouter.execute(event);
        ExecutionException thrown = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> {
            this.executionResult = (ExecutionResult)completableFuture.get();
        });
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.instanceOf(ComponentExecutionException.class));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.instanceOf(ExpressionRuntimeException.class)));
    }

    private void assertProcessorChainResult(Event returnedEvent) {
        MatcherAssert.assertThat((Object)returnedEvent.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"testPayload custom"));
        MatcherAssert.assertThat((Object)((TypedValue)returnedEvent.getVariables().get("myVar")).getValue(), (Matcher)Is.is((Object)"myVarValue"));
        MatcherAssert.assertThat((Object)((TypedValue)returnedEvent.getVariables().get("mySecondVar")).getValue(), (Matcher)Is.is((Object)"mySecondVarValue"));
        MatcherAssert.assertThat((Object)((TypedValue)returnedEvent.getVariables().get("myThirdVar")).getValue(), (Matcher)Is.is((Object)"myThirdVarValue"));
    }

    private InputEvent createInputEvent() {
        return InputEvent.create().message(Message.builder().value((Object)"testPayload").build()).addVariable("customVar", (Object)"Value");
    }
}

