/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInRelativeOrder;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.LifecycleTrackerRegistry;

@Feature(value="Error Handling")
@Story(value="Error Handler")
public class ErrorHandlerLifecycleTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private LifecycleTrackerRegistry trackersRegistry;
    @Inject
    @Named(value="flowA")
    private FlowConstruct flowA;
    @Inject
    @Named(value="flowB")
    private FlowConstruct flowB;
    @Inject
    @Named(value="flowC")
    private FlowConstruct flowC;
    @Inject
    @Named(value="flowD")
    private FlowConstruct flowD;
    @Inject
    @Named(value="flowE")
    private FlowConstruct flowE;
    @Inject
    @Named(value="flowF")
    private FlowConstruct flowF;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/default-error-handler-lifecycle.xml";
    }

    @Test
    public void testLifecycleErrorHandlerInFlow() throws Exception {
        this.flowRunner(this.flowA.getName()).run();
        this.flowRunner(this.flowB.getName()).run();
        List flowAErrorHandlerPhases = this.trackersRegistry.get("flowAErrorHandlerTracker").getCalledPhases();
        List flowBErrorHandlerPhases = this.trackersRegistry.get("flowBErrorHandlerTracker").getCalledPhases();
        MatcherAssert.assertThat((Object)flowAErrorHandlerPhases.contains("initialise"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)flowBErrorHandlerPhases.contains("initialise"), (Matcher)Is.is((Object)true));
        ((Lifecycle)this.flowA).stop();
        MatcherAssert.assertThat((Object)flowAErrorHandlerPhases.contains("stop"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)flowBErrorHandlerPhases.contains("stop"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testLifecycleReferencedErrorHandler() throws Exception {
        this.flowRunner(this.flowC.getName()).run();
        List defaultEhErrorHandlerPhases = this.trackersRegistry.get("esAErrorHandlerTracker").getCalledPhases();
        MatcherAssert.assertThat((Object)defaultEhErrorHandlerPhases, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"initialise", "start"}));
        ((Lifecycle)this.flowC).stop();
        ((Lifecycle)this.flowC).dispose();
        MatcherAssert.assertThat((Object)defaultEhErrorHandlerPhases, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"stop", "dispose"}));
    }

    @Test
    public void testLifecycleDefaultErrorHandler() throws Exception {
        this.flowRunner(this.flowD.getName()).run();
        List defaultEhErrorHandlerPhases = this.trackersRegistry.get("defaultEhErrorHandlerTracker").getCalledPhases();
        MatcherAssert.assertThat((Object)defaultEhErrorHandlerPhases, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"initialise", "start"}));
        ((Lifecycle)this.flowD).stop();
        ((Lifecycle)this.flowD).dispose();
        MatcherAssert.assertThat((Object)defaultEhErrorHandlerPhases.contains("stop"), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)defaultEhErrorHandlerPhases.contains("dispose"), (Matcher)Is.is((Object)false));
        ((Lifecycle)this.flowE).stop();
        ((Lifecycle)this.flowE).dispose();
        ((Lifecycle)this.flowF).stop();
        ((Lifecycle)this.flowF).dispose();
        MatcherAssert.assertThat((Object)defaultEhErrorHandlerPhases, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"stop", "dispose"}));
    }
}

