/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.core.context.notification.processors.ProcessorNotificationStore;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public abstract class AbstractLazyInitConfigurationComponentLocatorTestCase
extends AbstractIntegrationTestCase {
    protected static final String MY_SUB_FLOW = "mySubFlow";
    protected static final String FLOW_WITH_SUBFLOW = "flowWithSubflow";
    protected static final String[] EXPECTED_LOCATIONS = new String[]{"myFlow", "myFlow/source", "myFlow/source/0/0", "myFlow/processors/0", "myFlow/processors/1", "myFlow/processors/2", "myFlow/processors/2/processors/0", "myFlow/processors/2/processors/1", "anotherFlow", "anotherFlow/source", "anotherFlow/source/0/0", "anotherFlow/processors/0", "flowWithSubflow", "flowWithSubflow/processors/0", "mySubFlow", "mySubFlow/processors/0", "_muleConfiguration", "globalErrorHandler", "globalErrorHandler/0", "globalErrorHandler/0/processors/0", "flowFailing", "flowFailing/processors/0", "flowLvl0", "flowLvl0/processors/0", "flowLvl1", "flowLvl1/processors/0", "flowLvl2", "flowLvl2/processors/0", "flowLvl2/processors/1", "flowRecursive", "flowRecursive/processors/0", "dbConfig", "dbConfig/connection", "requestConfig", "requestConfig/connection", "tlsContextRef", "tlsContextRef/0", "anonymousProxyConfig", "globalObjectStore", "globalObjectStoreAggregatorFlow", "globalObjectStoreAggregatorFlow/processors/0", "globalObjectStoreAggregatorFlow/processors/0/route/0", "globalObjectStoreAggregatorFlow/processors/0/route/0/processors/0", "aggregatorWithMaxSizeFlow", "aggregatorWithMaxSizeFlow/processors/0", "aggregatorWithMaxSizeFlow/processors/1", "aggregatorWithMaxSizeListenerFlow", "aggregatorWithMaxSizeListenerFlow/source", "aggregatorWithMaxSizeListenerFlow/processors/0", "aggregatorOnListenerFlow", "aggregatorOnListenerFlow/processors/0", "justAnotherFlowThatShouldNotBeInitialized", "justAnotherFlowThatShouldNotBeInitialized/processors/0", "Matcher", "fileListWithMatcherReference", "fileListWithMatcherReference/source", "fileListWithMatcherReference/source/0/0", "fileListWithMatcherReference/processors/0", "listenerConfigRedeliveryPolicy", "listenerConfigRedeliveryPolicy/connection", "redeliveryPolicyFlow", "redeliveryPolicyFlow/source", "redeliveryPolicyFlow/source/0", "redeliveryPolicyFlow/processors/0", "redeliveryPolicyWithObjectStoreFlow", "redeliveryPolicyWithObjectStoreFlow/source", "redeliveryPolicyWithObjectStoreFlow/source/0", "redeliveryPolicyWithObjectStoreFlow/processors/0", "redeliveryPolicyFlowRef1", "redeliveryPolicyFlowRef1/processors/0", "redeliveryPolicyFlowRef2", "redeliveryPolicyFlowRef2/processors/0", "untilSuccessfulFlow", "untilSuccessfulFlow/processors/0", "untilSuccessfulFlow/processors/0/processors/0", "untilSuccessfulFlowCopy", "untilSuccessfulFlowCopy/processors/0", "untilSuccessfulFlowCopy/processors/0/processors/0", "multipleInitialize", "multipleInitialize/processors/0", "multipleInitialize/processors/1", "async-flow", "async-flow/processors/0", "async-flow/processors/0/processors/0", "invokeBeanFlow", "invokeBeanFlow/processors/0", "childBean", "myObjectStore", "notificationFlow", "notificationFlow/processors/0", "notificationLoggerObject", "null", "null/0", "null", "null/0", "os-config", "os-contains-flow", "os-contains-flow/processors/0"};
    protected static final int TOTAL_NUMBER_OF_LOCATIONS = EXPECTED_LOCATIONS.length;
    @Rule
    public DynamicPort listenPort = new DynamicPort("http.listener.port");
    @Rule
    public DynamicPort proxyPort = new DynamicPort("http.proxy.port");
    @Rule
    public SystemProperty path = new SystemProperty("path", "path");
    @Inject
    protected Registry registry;
    @Inject
    protected LazyComponentInitializer lazyComponentInitializer;

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/integration/locator/component-locator-config.xml", "org/mule/test/integration/locator/component-locator-notifications.xml", "org/mule/test/integration/locator/component-locator-levels-config.xml", "org/mule/test/integration/locator/component-locator-os-connector.xml", "org/mule/test/integration/locator/component-locator-reference-component-models.xml"};
    }

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    @Test
    public void whenInitializingComponentsDependingOnErrorTypesThenErrorTypesAreAlsoRegistered() {
        this.assertLocationsNotInitialized("redeliveryPolicyFlow", "redeliveryPolicyFlow/source");
        this.invokeInitializer(Location.builderFromStringRepresentation((String)"redeliveryPolicyFlow").build());
        this.assertLocationsInitialized("redeliveryPolicyFlow", "redeliveryPolicyFlow/source");
    }

    @Test
    public void whenReferencedFromJavaInvokeThenObjectIsInitialized() {
        Location javaInvokeOperationLocation = Location.builder().globalName("invokeBeanFlow").addProcessorsPart().addIndexPart(0).build();
        this.assertLocationsNotInitialized("invokeBeanFlow", javaInvokeOperationLocation.toString());
        this.invokeInitializer(javaInvokeOperationLocation);
        MatcherAssert.assertThat((Object)this.registry.lookupByName("childBean").isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void whenParameterDoesNotDefineStereotypeThenReferencedComponentIsAlsoInitialized() {
        this.assertLocationsNotInitialized("os-contains-flow", "os-contains-flow/processors/0", "os-config");
        this.invokeInitializer(Location.builderFromStringRepresentation((String)"os-contains-flow").build());
        this.assertLocationsInitialized("os-contains-flow", "os-contains-flow/processors/0", "os-config");
    }

    @Test
    public void whenComponentHasDeepTransitiveDependenciesThenTheyAreAllInitialized() {
        this.assertLocationsNotInitialized("flowLvl0", "flowLvl1", "flowLvl2", "dbConfig", "tlsContextRef", "anonymousProxyConfig");
        this.invokeInitializer(Location.builder().globalName("flowLvl0").build());
        this.assertLocationsInitialized("flowLvl0", "flowLvl0/processors/0");
        this.assertLocationsInitialized("flowLvl1", "flowLvl1/processors/0");
        this.assertLocationsInitialized("flowLvl2", "flowLvl2/processors/0", "flowLvl2/processors/1");
        this.assertLocationsInitialized("dbConfig", "requestConfig");
        this.assertLocationsInitialized("tlsContextRef", "anonymousProxyConfig");
        this.assertLocationsNotInitialized("listenerConfigRedeliveryPolicy");
    }

    @Test
    public void whenComponentHasRecursiveDependenciesThenTheyAreInitializedWithoutError() {
        this.assertLocationsNotInitialized("flowRecursive", "flowRecursive/processors/0");
        this.invokeInitializer(Location.builder().globalName("flowRecursive").build());
        this.assertLocationsInitialized("flowRecursive", "flowRecursive/processors/0");
    }

    @Test
    public void whenComponentIsFileListWithMatcherReferenceThenMatcherIsInitialized() {
        this.assertLocationsNotInitialized("fileListWithMatcherReference", "Matcher");
        this.invokeInitializer(Location.builderFromStringRepresentation((String)"fileListWithMatcherReference").build());
        this.assertLocationsInitialized("fileListWithMatcherReference", "Matcher");
    }

    @Description(value="Lazy init should create components that are references by other components, even when the reference is not a top level element")
    @Test
    public void whenComponentModelReferencesToNonTopLevelElementThenReferencedElementIsInitialized() {
        this.assertLocationsNotInitialized("aggregatorWithMaxSizeFlow/processors/0");
        this.invokeInitializer(Location.builder().globalName("aggregatorWithMaxSizeListenerFlow").build());
        this.assertLocationsInitialized("aggregatorWithMaxSizeFlow/processors/0");
        this.assertLocationsNotInitialized("aggregatorWithMaxSizeFlow", "aggregatorWithMaxSizeFlow/processors/1", "justAnotherFlowThatShouldNotBeInitialized");
    }

    @Description(value="Initialize flow and referenced sub-flow")
    @Test
    public void whenInitializingFlowReferencingSubFlowThenSubFlowIsAlsoInitialized() {
        Location mySubFlowLoggerLocation = Location.builder().globalName(MY_SUB_FLOW).addProcessorsPart().addIndexPart(0).build();
        Location flowRefLocation = Location.builder().globalName(FLOW_WITH_SUBFLOW).addProcessorsPart().addIndexPart(0).build();
        this.assertLocationsNotInitialized(FLOW_WITH_SUBFLOW, flowRefLocation.toString(), MY_SUB_FLOW, mySubFlowLoggerLocation.toString());
        this.invokeInitializer(Location.builderFromStringRepresentation((String)FLOW_WITH_SUBFLOW).build());
        this.assertLocationsInitialized(FLOW_WITH_SUBFLOW, flowRefLocation.toString(), MY_SUB_FLOW, mySubFlowLoggerLocation.toString());
    }

    @Test
    public void whenNotificationsAreDefinedThenTheyAreAlwaysInitialized() throws Exception {
        this.invokeInitializer(Location.builder().globalName("notificationFlow").build());
        this.flowRunner("notificationFlow").run();
        Collection processorNotificationStores = this.registry.lookupAllByType(ProcessorNotificationStore.class);
        MatcherAssert.assertThat((Object)processorNotificationStores, (Matcher)Matchers.hasSize((int)1));
        processorNotificationStores.stream().forEach(processorNotificationStore -> MatcherAssert.assertThat((Object)processorNotificationStore.getNotifications(), (Matcher)Matchers.hasSize((int)2)));
    }

    @Test
    @Issue(value="MULE-19928")
    @Description(value="Initialize an Object Store inside a redelivery policy")
    public void whenFlowHasListenerWithRedeliveryPolicyWithObjectStoreThenObjectStoreIsAlsoInitialized() {
        this.assertLocationsNotInitialized("redeliveryPolicyWithObjectStoreFlow", "myObjectStore");
        this.invokeInitializer(Location.builder().globalName("redeliveryPolicyWithObjectStoreFlow").build());
        this.assertLocationsInitialized("redeliveryPolicyWithObjectStoreFlow", "myObjectStore");
    }

    protected void assertFlowsInitialized(String ... expectedFlowNames) {
        List flowNames = this.locator.find(ComponentIdentifier.buildFromStringRepresentation((String)"flow")).stream().map(c -> ((NamedObject)c).getName()).collect(Collectors.toList());
        MatcherAssert.assertThat(flowNames, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFlowNames));
    }

    protected void assertLocationsInitialized(String ... expectedLocations) {
        for (String location : expectedLocations) {
            MatcherAssert.assertThat((String)String.format("%s is not initialized", location), (Object)this.locator.find(Location.builderFromStringRepresentation((String)location).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        }
    }

    protected void assertLocationsNotInitialized(String ... expectedLocations) {
        for (String location : expectedLocations) {
            MatcherAssert.assertThat((String)String.format("%s is initialized", location), (Object)this.locator.find(Location.builderFromStringRepresentation((String)location).build()), (Matcher)Matchers.is(Optional.empty()));
        }
    }

    protected abstract void invokeInitializer(Location var1);
}

