/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.validation.api.ValidationException;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Routers")
@Story(value="First Successful")
public class FirstSuccessfulTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return "first-successful-test.xml";
    }

    @Test
    public void firstRouteWorks() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("test-router").withPayload((Object)"XYZ")).run().getMessage();
        MatcherAssert.assertThat((Object)this.getPayloadAsString(response), (Matcher)CoreMatchers.is((Object)"XYZ is a string"));
    }

    @Test
    public void secondRouteWorks() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("test-router").withPayload((Object)9)).run().getMessage();
        MatcherAssert.assertThat((Object)this.getPayloadAsString(response), (Matcher)CoreMatchers.is((Object)"9 is a number"));
        response = ((FlowRunner)this.flowRunner("test-router").withPayload((Object)42L)).run().getMessage();
        MatcherAssert.assertThat((Object)this.getPayloadAsString(response), (Matcher)CoreMatchers.is((Object)"42 is a number"));
    }

    @Test
    public void allRoutesFail() throws Exception {
        this.expectedError.expectCause(CoreMatchers.instanceOf(ValidationException.class));
        this.expectedError.expectErrorType("VALIDATION", "INVALID_BOOLEAN");
        ((FlowRunner)this.flowRunner("test-router").withPayload((Object)Boolean.TRUE)).run().getMessage();
    }

    @Test
    public void nestedFirstSuccessful() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("nestedFirstSuccessful").withPayload((Object)"test")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test hello"));
    }

    @Test
    public void oneWayEndpoints() throws Exception {
        ((FlowRunner)this.flowRunner("withOneWayEndpoints").withPayload((Object)"Test Message")).run();
        Message response = this.queueManager.read("WithOneWayEndpoints.out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"Test Message"));
    }

    @Test
    public void insideErrorHandler() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("firstSuccessfulInErrorHandler").withPayload((Object)"test")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"La pelota no se mancha"));
    }

    @Test
    public void insideErrorHandlerWithError() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("firstSuccessfulInErrorHandlerWithError").withPayload((Object)"test")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"Yo me equivoque y pague"));
    }

    @Test
    public void insideErrorHandlerFailing() throws Exception {
        this.expectedError.expectCause(CoreMatchers.instanceOf(ValidationException.class));
        this.expectedError.expectErrorType("VALIDATION", "INVALID_BOOLEAN");
        ((FlowRunner)this.flowRunner("firstSuccessfulInErrorHandlerWithFailing").withPayload((Object)Boolean.TRUE)).run().getMessage();
    }

    @Test
    @Issue(value="MULE-19169")
    public void firstSuccessfulInsideParalleLForEach() throws Exception {
        CoreEvent event = this.flowRunner("firstSuccessfulInParallelForEach").run();
        MatcherAssert.assertThat((Object)this.getPayloadAsString(event.getMessage()), (Matcher)CoreMatchers.is((Object)"Se te escapo la tortuga"));
        MatcherAssert.assertThat((Object)((TypedValue)event.getVariables().get("wasExecuted")).getValue(), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    @Issue(value="W-10619792")
    @Description(value="When a First Successful is followed by a Raise Error inside a Scatter Gather's route, should error.")
    public void firstSuccessfulAndRaiseErrorInsideScatterGather() throws Exception {
        this.expectedError.expectErrorType("MULE", "COMPOSITE_ROUTING");
        this.flowRunner("firstSuccessfulAndRaiseErrorInsideScatterGather").run();
    }

    @Test
    @Issue(value="W-12552091")
    @Description(value="When a First Successful invokes a flow that has a raise error, then it should still proceed to next route.")
    public void FirstSuccessfulToFlowWithError() throws Exception {
        CoreEvent result = this.flowRunner("FirstSuccessfulToFlowWithError").run();
        MatcherAssert.assertThat((Object)this.getPayloadAsString(result.getMessage()), (Matcher)CoreMatchers.is((Object)"A Di Maria me lo resistian"));
    }
}

