/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
public class HttpListenerTlsInsecureTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public SystemProperty sslCacerts = new SystemProperty("sslCacerts", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslCaCerts());
    @Rule
    public SystemProperty sslTestKeyStore = new SystemProperty("sslTestKeyStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslKeyStore());
    @Rule
    public SystemProperty serverKeyStore = new SystemProperty("serverKeyStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestServerKeyStore());
    @Rule
    public SystemProperty password = new SystemProperty("password", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().resolveStorePassword("changeit"));
    @Rule
    public SystemProperty storeType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return "http-listener-tls-insecure-config.xml";
    }

    @Test
    public void acceptsInvalidCertificateIfInsecure() throws Exception {
        CoreEvent res = ((FlowRunner)((FlowRunner)this.flowRunner("testRequestToInsecure").withPayload((Object)"test")).withVariable("port", (Object)this.port1.getNumber())).run();
        MatcherAssert.assertThat((Object)res.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"test"));
    }

    @Test
    public void rejectsInvalidCertificateIfSecure() throws Exception {
        this.expectedError.expectCause(CoreMatchers.instanceOf(IOException.class));
        this.expectedError.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Remotely close")));
        ((FlowRunner)((FlowRunner)this.flowRunner("testRequestToSecure").withPayload((Object)"data")).withVariable("port", (Object)this.port2.getNumber())).run();
    }
}

