/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.matcher;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.runtime.core.api.util.IOUtils;

public class HttpResponseContentStringMatcher
extends TypeSafeMatcher<HttpResponse> {
    private Matcher<String> matcher;
    private String responseContent = null;

    public HttpResponseContentStringMatcher(Matcher<String> matcherToUse) {
        this.matcher = matcherToUse;
    }

    public boolean matchesSafely(HttpResponse response) {
        try {
            this.responseContent = IOUtils.toString((InputStream)response.getEntity().getContent());
        }
        catch (IOException e) {
            this.responseContent = null;
        }
        return this.matcher.matches((Object)this.responseContent);
    }

    public void describeTo(Description description) {
        description.appendText("a response which body ").appendDescriptionOf(this.matcher);
    }

    protected void describeMismatchSafely(HttpResponse response, Description mismatchDescription) {
        mismatchDescription.appendText("was ").appendValue((Object)this.responseContent);
    }

    public static Matcher<HttpResponse> body(Matcher<String> matcher) {
        return new HttpResponseContentStringMatcher(matcher);
    }
}

