/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.sni;

import io.qameta.allure.Feature;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;
import org.mule.tls.sni.HttpsTestServerEnforcingSNI;

@Feature(value="TLS/SSL")
public class HttpsRequesterSniTestCase
extends AbstractIntegrationTestCase {
    private static final String FQDN = "localhost.localdomain";
    private static final String SERVER_PROTOCOL_ENABLED = "SSLv3,TLSv1,TLSv1.1,TLSv1.2";
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();
    @Rule
    public DynamicPort httpsPort = new DynamicPort("httpsPort");
    @Rule
    public SystemProperty password = new SystemProperty("password", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().resolveStorePassword("changeit"));
    @Rule
    public SystemProperty sniClientTruststore = new SystemProperty("sniClientTruststore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSniClientTrustStore());
    @Rule
    public SystemProperty storeType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    private HttpsTestServerEnforcingSNI server;

    protected String getConfigFile() {
        return "http-request-sni-config.xml";
    }

    @BeforeClass
    public static void createTlsPropertiesFile() throws Exception {
        PrintWriter writer = new PrintWriter(HttpsRequesterSniTestCase.getTlsPropertiesFile(), StandardCharsets.UTF_8);
        writer.println("enabledProtocols=SSLv3,TLSv1,TLSv1.1,TLSv1.2");
        writer.close();
    }

    @AfterClass
    public static void removeTlsPropertiesFile() {
        HttpsRequesterSniTestCase.getTlsPropertiesFile().delete();
    }

    private static File getTlsPropertiesFile() {
        String path = System.getProperty("testClasspathDir");
        if (path == null) {
            path = ClassUtils.getClassPathRoot(HttpsRequesterSniTestCase.class).getPath();
        }
        return new File(path, "tls-default.conf");
    }

    @Before
    public void prepareServer() throws IOException, URISyntaxException {
        this.server = new HttpsTestServerEnforcingSNI(this.httpsPort.getNumber());
        this.server.startServer();
    }

    @After
    public void teardownServer() {
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    @Test
    public void testClientSNINotSentOnNonFQDN() {
        FlowRunner flowRunner = (FlowRunner)this.flowRunner("requestFlowLocalhost").withPayload((Object)"Test Message");
        Exception error = (Exception)Assert.assertThrows(Exception.class, () -> ((FlowRunner)flowRunner).run());
        MatcherAssert.assertThat((Object)error, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Remotely closed")));
    }

    @Test
    public void testClientSNISentOnFQDN() throws Exception {
        HttpsRequesterSniTestCase.assumeFqdnWorksForThisTest(FQDN);
        ((FlowRunner)this.flowRunner("requestFlowFQDN").withPayload((Object)"Test Message")).run();
        MatcherAssert.assertThat((Object)this.server.getHostname(), (Matcher)Is.is((Object)FQDN));
    }

    private static void assumeFqdnWorksForThisTest(String fqdn) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(fqdn);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assume.assumeThat((String)"SNI requires a fully qualified domain name. \"%s\" is used but it is not commonly present on MacOSX hosts. An assumption will prevent its execution unless the domain exists. Although is recommended to add the aforementioned domain to the /etc/hosts file if it's not present.".formatted(fqdn), (Object)address, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
    }
}

