/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.junit4;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;
import org.reactivestreams.Publisher;

public class FlowRunnerTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    protected String getConfigFile() {
        return "org/mule/functional/junit4/flow-runner-config.xml";
    }

    @Test
    public void flowFinishesSuccessfullyWhenExpectingException() throws Exception {
        Exception exception = this.flowRunner("okFailFlow").runExpectingException();
        Assert.assertNotNull((Object)exception);
    }

    @Test
    public void flowRunFailsEvenWhenExpectingException() throws Exception {
        this.exception.expect(AssertionError.class);
        this.exception.expectMessage("evaluated false");
        Exception exception = this.flowRunner("badFailFlow").runExpectingException();
        throw exception;
    }

    @Test
    @Issue(value="MULE-19444")
    public void applyIsCalledOnlyDuringStartup() throws Exception {
        Assert.assertThat((Object)TestProcessor.applyCalled, (Matcher)Matchers.is((Object)true));
        TestProcessor.applyCalled = false;
        this.flowRunner("okFlow").run();
        Assert.assertThat((Object)TestProcessor.applyCalled, (Matcher)Matchers.is((Object)false));
    }

    public static class TestProcessor
    implements Processor {
        static boolean applyCalled = false;

        public CoreEvent process(CoreEvent event) throws MuleException {
            return event;
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            applyCalled = true;
            return publisher;
        }
    }
}

