/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.interception.FlowInterceptor;
import org.mule.runtime.api.interception.FlowInterceptorFactory;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.integration.interception.ProcessorInterceptorFactoryTestCase;

@Feature(value="Interception API")
@Story(value="Flow Interception Story")
public class FlowInterceptorFactoryCustomActionTestCase
extends AbstractIntegrationTestCase {
    private static AtomicInteger counter = new AtomicInteger();
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Inject
    @Named(value="counting")
    public Flow counting;

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/flow-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_CustomActionInterceptorFactory", new CustomActionInterceptorFactory());
        return objects;
    }

    @Before
    public void before() {
        counter = new AtomicInteger();
        CustomActionInterceptor.actioner = (flowName, action) -> action.proceed();
    }

    @After
    public void after() {
        ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters.clear();
    }

    @Test
    public void proceedFlowRef() throws Exception {
        this.expectedError.expectErrorType("APP", "ERROR");
        this.flowRunner("flowRefOuter").run();
    }

    @Test
    public void proceedDataWeaveLookup() throws Exception {
        this.expectedError.expectErrorType("MULE", "EXPRESSION");
        this.flowRunner("lookupOuter").run();
    }

    @Test
    public void skipFlowRef() throws Exception {
        this.skipFlow("flowFailing");
        this.flowRunner("flowRefOuter").run();
    }

    @Test
    public void skipDataWeaveLookup() throws Exception {
        this.skipFlow("flowFailing");
        this.flowRunner("lookupOuter").run();
    }

    @Test
    public void skipFlowWithSource() throws Exception {
        this.skipFlow("counting");
        this.counting.start();
        Thread.sleep(5000L);
        MatcherAssert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)0));
    }

    private void skipFlow(String skipFlowName) {
        CustomActionInterceptor.actioner = (flowName, action) -> {
            if (skipFlowName.equals(flowName)) {
                return action.skip();
            }
            return action.proceed();
        };
    }

    @Test
    public void interceptorFailAction() throws Exception {
        IllegalStateException expected = new IllegalStateException();
        CustomActionInterceptor.actioner = (flowName, action) -> {
            if ("counting".equals(flowName)) {
                return action.fail((Throwable)expected);
            }
            return action.proceed();
        };
        this.flowRunner("counting").runExpectingException(Matchers.sameInstance((Object)expected));
    }

    @Test
    public void interceptorFailHandledBySource() throws Exception {
        IllegalStateException expected = new IllegalStateException();
        CustomActionInterceptor.actioner = (flowName, action) -> {
            if ("countingHttpServer".equals(flowName)) {
                return action.fail((Throwable)expected);
            }
            return action.proceed();
        };
        this.flowRunner("countingHttpClient").run();
    }

    public static Object count(Object payload) {
        counter.incrementAndGet();
        return payload;
    }

    public static class CustomActionInterceptorFactory
    implements FlowInterceptorFactory {
        public FlowInterceptor get() {
            return new CustomActionInterceptor();
        }
    }

    public static class CustomActionInterceptor
    implements FlowInterceptor {
        private static BiFunction<String, InterceptionAction, CompletableFuture<InterceptionEvent>> actioner = (flowName, action) -> action.proceed();

        public CompletableFuture<InterceptionEvent> around(String flowName, InterceptionEvent event, InterceptionAction action) {
            return actioner.apply(flowName, action);
        }
    }
}

