/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.test.AbstractIntegrationTestCase;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public class ErrorHandlerLazyInitTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private Registry registry;
    @Inject
    @Named(value="_muleLazyComponentInitializer")
    private LazyComponentInitializer lazyComponentInitializer;

    protected String getConfigFile() {
        return "org/mule/test/integration/locator/component-locator-error-mapping.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    @Test
    public void registerCustomErrorsFromErrorHandler() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("mainFlow").build(), "APP:ERROR_TYPE_1", "APP:ERROR_TYPE_2");
    }

    @Test
    public void registerCustomErrorsFromErrorMapping() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("errorMappingFlow").build(), "APP:ERROR_TYPE_1", "APP:ERROR_TYPE_2", "APP:ERROR_TYPE_MAPPING_1");
    }

    @Test
    @Issue(value="MULE-18286")
    public void errorIsRegisteredButComponentIsNotAnnotated() throws Exception {
        Location location = Location.builder().globalName("errorMappingFlow").build();
        this.lazyComponentInitializer.initializeComponent(location);
        this.flowRunner("errorMappingFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR_TYPE_MAPPING_1"));
    }

    @Test
    @Issue(value="MULE-18286")
    public void errorIsRegisteredButComponentIsNotAnnotatedEvenWhenInitializedTwice() throws Exception {
        Location errorMappingFlowLocation = Location.builder().globalName("errorMappingFlow").build();
        this.lazyComponentInitializer.initializeComponent(errorMappingFlowLocation);
        this.flowRunner(errorMappingFlowLocation.getGlobalName()).runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR_TYPE_MAPPING_1"));
        Location errorMappingFlow2Location = Location.builder().globalName("errorMappingFlow2").build();
        this.lazyComponentInitializer.initializeComponent(errorMappingFlow2Location);
        this.flowRunner(errorMappingFlow2Location.getGlobalName()).runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR_TYPE_MAPPING_2"));
        this.lazyComponentInitializer.initializeComponent(errorMappingFlowLocation);
        this.flowRunner(errorMappingFlowLocation.getGlobalName()).runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR_TYPE_MAPPING_1"));
    }

    @Test
    public void emptyRaiseErrorType() {
        Location location = Location.builder().globalName("emptyRaiseErrorType").build();
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.doCustomErrorTypesShouldDiscoveredTest(location, new String[0]));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"type cannot be an empty string or null"));
    }

    @Test
    public void invalidErrorTypeOnRaiseError() {
        Location location = Location.builder().globalName("invalidErrorTypeOnRaiseError").build();
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.doCustomErrorTypesShouldDiscoveredTest(location, new String[0]));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"There's no MULE error named 'ERROR_NON_EXISTING"));
    }

    @Test
    public void invalidErrorTypeOnErrorHandler() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("invalidErrorTypeOnErrorHandler").build(), "ERROR_NON_EXISTING_1");
    }

    @Test
    @Issue(value="MULE-18805")
    @Description(value="Checks that configuration can be built when having an onError")
    public void withOnErrorReference() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("withSharedContinue").build(), new String[0]);
    }

    @Test
    @Issue(value="MULE-18805")
    @Description(value="Checks that configuration can be built when having an onError in a global error handler")
    public void globalErrorHandlerWithOnError() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("globalErrorHandlerWithOnError").build(), new String[0]);
    }

    @Test
    public void registerCustomErrorsFromErrorMappingOnlyOnce() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("errorMappingFlow").build(), "APP:ERROR_TYPE_1", "APP:ERROR_TYPE_2", "APP:ERROR_TYPE_MAPPING_1");
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("errorMappingFlow2").build(), "APP:ERROR_TYPE_1", "APP:ERROR_TYPE_2", "APP:ERROR_TYPE_MAPPING_2");
    }

    @Test
    public void registerCustomErrorsFromRaiseError() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("raiseErrorSubFlow").build(), "APP:ERROR_TYPE_1");
    }

    @Test
    public void notEnabledErrorFlow() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("notEnabledFlow").build(), "APP:ERROR_TYPE_1", "APP:ERROR_TYPE_3");
    }

    @Test
    public void errorShouldNotBeRegisteredFromErrorHandlerNotReferenced() {
        this.doCustomErrorTypesShouldDiscoveredTest(Location.builder().globalName("notEnabledErrorHandler").build(), "APP:ERROR_TYPE_4");
    }

    @Test
    public void whenLazyInitializeAdditionalComponentThenErrorsAreRegistered() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("errorMappingFlow").build());
        this.checkErrorTypesAreRegistered(false, "APP:ERROR_TYPE_3");
        this.registry.lookupByName("notEnabledFlow");
        this.checkErrorTypesAreRegistered("APP:ERROR_TYPE_1", "APP:ERROR_TYPE_2", "APP:ERROR_TYPE_MAPPING_1", "APP:ERROR_TYPE_3");
    }

    @Test
    public void whenLazyInitializeAdditionalComponentThenComponentsAreAnnotated() throws Exception {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("errorMappingFlow").build());
        this.flowRunner("errorMappingFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR_TYPE_MAPPING_1"));
        this.flowRunner("notEnabledFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR_TYPE_3"));
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("errorMappingFlow2").build());
        this.flowRunner("errorMappingFlow2").runExpectingException(ErrorTypeMatcher.errorType((String)"APP", (String)"ERROR_TYPE_MAPPING_2"));
    }

    private void checkErrorTypesAreRegistered(boolean includeErrorTypes, String ... errorTypes) {
        ErrorTypeRepository errorTypeRepository = (ErrorTypeRepository)this.registry.lookupByType(ErrorTypeRepository.class).orElseThrow(() -> new AssertionError((Object)"Cannot access errorTypeRepository"));
        Arrays.stream(errorTypes).forEach(errorType -> {
            Optional appMyErrorType = errorTypeRepository.getErrorType(ComponentIdentifier.buildFromStringRepresentation((String)errorType));
            if (includeErrorTypes) {
                MatcherAssert.assertThat((String)errorType, (Object)appMyErrorType, (Matcher)IsNot.not(Optional.empty()));
                MatcherAssert.assertThat((String)errorType, (Object)((ErrorType)appMyErrorType.get()).getParentErrorType(), (Matcher)IsEqual.equalTo((Object)errorTypeRepository.getAnyErrorType()));
            } else {
                MatcherAssert.assertThat((String)errorType, (Object)appMyErrorType, (Matcher)IsEqual.equalTo(Optional.empty()));
            }
        });
    }

    private void checkErrorTypesAreRegistered(String ... errorTypes) {
        this.checkErrorTypesAreRegistered(true, errorTypes);
    }

    private void doCustomErrorTypesShouldDiscoveredTest(Location location, boolean includeErrorTypes, String ... errorTypes) {
        this.lazyComponentInitializer.initializeComponent(location);
        this.checkErrorTypesAreRegistered(includeErrorTypes, errorTypes);
    }

    private void doCustomErrorTypesShouldDiscoveredTest(Location location, String ... errorTypes) {
        this.doCustomErrorTypesShouldDiscoveredTest(location, true, errorTypes);
    }
}

