/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tls.fips;

/**
 * A concrete implementation of {@link TestConfiguration} that is used for testing in environments with FIPS (Federal Information
 * Processing Standards) compliance. This class provides configurations specific to FIPS-compliant tests.
 */
public class FipsTestConfiguration implements TestConfiguration {

  private static final String FIPS_TEST_STORE_PASSWORD = "mulepassword";
  private static final String FIPS_TEST_STORE_TYPE = "bcfks";
  private static final String FIPS_TEST_SSL_CA_CERTS = "tls/ssltest-cacerts-fips.bcfks";
  private static final String FIPS_TEST_SSL_KEY_STORE = "tls/ssltest-keystore-fips.bcfks";
  private static final String FIPS_TLS_SERVER_KEYSTORE = "tls/serverKeystoreFips";
  private static final String FIPS_TEST_GENERIC_TRUST_KEY_STORE = "tls/trustStoreFips";
  private static final String FIPS_CERTIFICATE_AUTHORITY_ENTITY = "tls/crl/certificate-authority-entity.bcfks";
  private static final String FIPS_TRUST_FILE_FOR_CRL = "tls/crl/trustFile-fips.bcfks";
  private static final String FIPS_TLS_SNI_CLIENT_TRUSTSTORE = "tls/sni-client-truststore-fips.bcfks";
  private static final String FIPS_TLS_SSLTEST_KEYSTORE_WITH_TEST_HOSTNAME = "tls/ssltest-keystore-with-test-hostname-fips.bcfks";
  private static final String FIPS_TLS_CLIENT_KEYSTORE = "tls/clientKeystoreFips";
  private static final String FIPS_TLS_CLIENT_KEY_STORE_WITH_MULTIPLE_KEYS = "tls/clientServerKeyStoreFips";
  private static final String FIPS_TLS_TRUST_STORE_FILE_WITHOUT_MULE_SERVER_CERTIFICATE =
      "tls/trustStoreWithoutMuleServerCertificateFips";
  private static final String FIPS_TEST_CIPHER_SUITE = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
  private static final String FIPS_TLS_SSLTEST_KEYSTORE_INVALID = "tls/ssltest-keystore-invalid.bcfks";

  @Override
  public String getKeyStorePKS12Type() {
    return FIPS_TEST_STORE_TYPE;
  }

  @Override
  public String getTrustStoreJCEKSType() {
    return FIPS_TEST_STORE_TYPE;
  }

  @Override
  public String resolveStorePassword(String defaultPassword) {
    return FIPS_TEST_STORE_PASSWORD;
  }

  @Override
  public String getCertificateAuthorityEntity() {
    return FIPS_CERTIFICATE_AUTHORITY_ENTITY;
  }

  @Override
  public String getTrustFileForCrl() {
    return FIPS_TRUST_FILE_FOR_CRL;
  }

  @Override
  public String getTestSniClientTrustStore() {
    return FIPS_TLS_SNI_CLIENT_TRUSTSTORE;
  }

  @Override
  public String getTestStoreType() {
    return FIPS_TEST_STORE_TYPE;
  }

  @Override
  public String getTestSslCaCerts() {
    return FIPS_TEST_SSL_CA_CERTS;
  }

  @Override
  public String getTestSslKeyStore() {
    return FIPS_TEST_SSL_KEY_STORE;
  }

  @Override
  public String getTestStorePassword() {
    return FIPS_TEST_STORE_PASSWORD;
  }

  @Override
  public String getTestSslKeyStoreWithHostName() {
    return FIPS_TLS_SSLTEST_KEYSTORE_WITH_TEST_HOSTNAME;
  }

  @Override
  public String getTestServerKeyStore() {
    return FIPS_TLS_SERVER_KEYSTORE;
  }

  @Override
  public String getTestGenericTrustKeyStore() {
    return FIPS_TEST_GENERIC_TRUST_KEY_STORE;
  }

  @Override
  public String getTestClientKeyStore() {
    return FIPS_TLS_CLIENT_KEYSTORE;
  }

  @Override
  public String getTlsClientKeyStoreWithMultipleKeys() {
    return FIPS_TLS_CLIENT_KEY_STORE_WITH_MULTIPLE_KEYS;
  }

  @Override
  public String getTlsTrustStoreFileWithoutMuleServerCertificate() {
    return FIPS_TLS_TRUST_STORE_FILE_WITHOUT_MULE_SERVER_CERTIFICATE;
  }

  @Override
  public String getTestCipherSuite() {
    return FIPS_TEST_CIPHER_SUITE;
  }

  @Override
  public String getInvalidTestKeyStore() {
    return FIPS_TLS_SSLTEST_KEYSTORE_INVALID;
  }

}
