/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.matcher;

import org.apache.http.HttpResponse;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HttpResponseStatusCodeMatcher
extends TypeSafeMatcher<HttpResponse> {
    private int statusCode;

    public HttpResponseStatusCodeMatcher(int statusCode) {
        this.statusCode = statusCode;
    }

    public boolean matchesSafely(HttpResponse response) {
        return response.getStatusLine().getStatusCode() == this.statusCode;
    }

    public void describeTo(Description description) {
        description.appendText("a response with status code ").appendValue((Object)this.statusCode);
    }

    protected void describeMismatchSafely(HttpResponse response, Description mismatchDescription) {
        mismatchDescription.appendText("got a response with status code ").appendValue((Object)response.getStatusLine().getStatusCode());
    }

    public static Matcher<HttpResponse> hasStatusCode(int statusCode) {
        return new HttpResponseStatusCodeMatcher(statusCode);
    }
}

