/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInRelativeOrder;
import org.junit.Test;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.LifecycleTrackerRegistry;

@Feature(value="Error Handling")
@Story(value="Global Error Handler")
public class GlobalErrorHandlerLifecycleTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private LifecycleTrackerRegistry trackersRegistry;
    @Inject
    @Named(value="globalFlow1")
    private FlowConstruct globalFlow1;
    @Inject
    @Named(value="globalFlow2")
    private FlowConstruct globalFlow2;
    @Inject
    @Named(value="anotherGlobalFlow1")
    private FlowConstruct anotherGlobalFlow1;
    @Inject
    @Named(value="anotherGlobalFlow2")
    private FlowConstruct anotherGlobalFlow2;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/global-error-handler-lifecycle.xml";
    }

    @Test
    public void testLifecycleGlobalErrorHandler() throws Exception {
        this.flowRunner(this.anotherGlobalFlow1.getName()).run();
        List globalErrorHandlerTracker = this.trackersRegistry.get("anotherGlobalErrorHandlerTracker").getCalledPhases();
        MatcherAssert.assertThat((Object)globalErrorHandlerTracker, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"initialise", "start"}));
        ((Lifecycle)this.anotherGlobalFlow1).stop();
        ((Lifecycle)this.anotherGlobalFlow1).dispose();
        MatcherAssert.assertThat((Object)globalErrorHandlerTracker, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"stop")));
        MatcherAssert.assertThat((Object)globalErrorHandlerTracker, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"dispose")));
        ((Lifecycle)this.anotherGlobalFlow2).stop();
        ((Lifecycle)this.anotherGlobalFlow2).dispose();
        MatcherAssert.assertThat((Object)globalErrorHandlerTracker, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"stop", "dispose"}));
    }

    @Test
    public void testStopAndStartGlobalErrorHandler() throws Exception {
        this.flowRunner(this.globalFlow1.getName()).run();
        this.flowRunner(this.globalFlow2.getName()).run();
        List globalErrorHandlerTracker = this.trackersRegistry.get("globalErrorHandlerTracker").getCalledPhases();
        MatcherAssert.assertThat((Object)globalErrorHandlerTracker, (Matcher)IsIterableContainingInRelativeOrder.containsInRelativeOrder((Object[])new String[]{"initialise", "start"}));
        ((Lifecycle)this.globalFlow1).stop();
        this.flowRunner(this.globalFlow2.getName()).run();
        ((Lifecycle)this.globalFlow1).start();
        this.flowRunner(this.globalFlow1.getName()).run();
        ((Lifecycle)this.globalFlow1).stop();
        ((Lifecycle)this.globalFlow2).stop();
        ((Lifecycle)this.globalFlow1).dispose();
        ((Lifecycle)this.globalFlow2).dispose();
        MatcherAssert.assertThat((Object)globalErrorHandlerTracker, (Matcher)CoreMatchers.hasItem((Object)"dispose"));
    }

    @Test
    public void clearChainInStop() throws MuleException {
        FlowExceptionHandler globalErrorHandler = this.globalFlow1.getMuleContext().getDefaultErrorHandler(Optional.empty());
        Map routers = globalErrorHandler.getRouters();
        int size = routers.size();
        Optional<Component> forGlobalReference = routers.keySet().stream().filter(component -> component.toString().contains(this.globalFlow1.getName())).findFirst();
        MatcherAssert.assertThat((Object)forGlobalReference.isPresent(), (Matcher)Matchers.is((Object)true));
        ((Lifecycle)this.globalFlow1).stop();
        forGlobalReference = routers.keySet().stream().filter(component -> component.toString().contains(this.globalFlow1.getName())).findFirst();
        MatcherAssert.assertThat((Object)forGlobalReference.isPresent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)routers.size(), (Matcher)Matchers.is((Object)(size - 1)));
    }
}

