/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.TlsTestUtils;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
public class TlsContextCustomCiphersTestCase
extends AbstractIntegrationTestCase {
    public static final String NO_USABLE_PROTOCOLS_ENABLED_MESSAGE = "No usable protocols enabled";
    @ClassRule
    public static DynamicPort httpsInternalPort1 = new DynamicPort("internal.port.1");
    @ClassRule
    public static DynamicPort httpsInternalPort2 = new DynamicPort("internal.port.2");
    @ClassRule
    public static DynamicPort httpsInternalPort3 = new DynamicPort("internal.port.3");
    private static final String invalidCipher = "TLS_RSA_WITH_AES_256_CBC_SHA";
    private static final String bothProtocolsOneCipher = "bothProtocolsOneCipher";
    private static final String validProtocolValidCipher = "validProtocolValidCipher";
    private static final String validProtocolInvalidCipher = "validProtocolInvalidCipher";
    private static final String OK_RESPONSE = "ok";
    private static final String ERROR_RESPONSE = "Remotely closed";
    @ClassRule
    public static SystemProperty cipherSuites = new SystemProperty("cipherSuites", "TLS_RSA_WITH_AES_256_CBC_SHA");
    @ClassRule
    public static SystemProperty verboseExceptions = new SystemProperty("mule.verbose.exceptions", "true");
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @ClassRule
    public static SystemProperty sslCacerts = new SystemProperty("sslCacerts", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslCaCerts());
    @ClassRule
    public static SystemProperty sslTestKeyStore = new SystemProperty("sslKeyStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslKeyStore());
    @ClassRule
    public static SystemProperty password = new SystemProperty("password", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().resolveStorePassword("changeit"));
    @ClassRule
    public static SystemProperty storeType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    @ClassRule
    public static SystemProperty cipherSuite = new SystemProperty("cipherSuite", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestCipherSuite());

    protected String getConfigFile() {
        return "tls-ciphers-config.xml";
    }

    @Test
    public void testBothProtocolsOneCipher() throws Exception {
        MatcherAssert.assertThat((Object)this.flowRunner(bothProtocolsOneCipher).keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)OK_RESPONSE)));
    }

    @Test
    public void testValidProtocolValidCipher() throws Exception {
        MatcherAssert.assertThat((Object)this.flowRunner(validProtocolValidCipher).keepStreamsOpen().run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)OK_RESPONSE)));
    }

    @Test
    public void testValidProtocolInvalidCipher() throws Exception {
        this.expectedError.expectErrorType("HTTP", "CONNECTIVITY");
        this.expectedError.expectMessage((Matcher)Matchers.anyOf((Matcher)CoreMatchers.containsString((String)ERROR_RESPONSE), TlsTestUtils.sslValidationError(), (Matcher)CoreMatchers.containsString((String)NO_USABLE_PROTOCOLS_ENABLED_MESSAGE)));
        this.flowRunner(validProtocolInvalidCipher).run();
    }
}

