/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.crl.client;

import io.qameta.allure.Feature;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Rule;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tls.crl.AbstractHttpTlsRevocationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
@RunnerDelegateTo(value=Parameterized.class)
public abstract class AbstractHttpRequesterClrTestCase
extends AbstractHttpTlsRevocationTestCase {
    @Rule
    public SystemProperty trustStoreType = new SystemProperty("trustStoreType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTrustStoreJCEKSType());
    @Rule
    public SystemProperty trustStore = new SystemProperty("truststore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTrustFileForCrl());
    @Rule
    public SystemProperty keyStoreType = new SystemProperty("keyStoreType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getKeyStorePKS12Type());
    @Rule
    public SystemProperty keyStore = new SystemProperty("keystore", this.getEntity1KeyStore());
    @Rule
    public SystemProperty storeType = new SystemProperty("keyStoreType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getKeyStorePKS12Type());
    @Rule
    public SystemProperty certificationAuthority = new SystemProperty("certificationAuthority", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getCertificateAuthorityEntity());
    @Rule
    public SystemProperty password = new SystemProperty("password", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().resolveStorePassword("test"));

    protected AbstractHttpRequesterClrTestCase(String configFile, String crlPath, String entityCertified) {
        super(configFile, crlPath, entityCertified);
    }

    @Parameterized.Parameters
    public static Collection<Object> data() {
        if (DefaultTestConfiguration.isFipsTesting()) {
            return Arrays.asList("http-requester-tls-revocation-file-config.xml");
        }
        return Arrays.asList("http-requester-tls-revocation-file-config.xml", "http-requester-tls-revocation-crl-standard-config.xml");
    }

    public boolean addToolingObjectsToRegistry() {
        return true;
    }

    private String getEntity1KeyStore() {
        if (DefaultTestConfiguration.isFipsTesting()) {
            return "tls/crl/entity1-fips.bcfks";
        }
        return "tls/crl/entity1";
    }
}

