/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Lazy Initialization")
@Story(value="Custom object serializer")
public class CustomObjectSerializerLazyInitTestCase
extends AbstractIntegrationTestCase {
    private static final String FIRST_LOCATION = "flow1";
    private static final String SECOND_LOCATION = "flow2";
    @Inject
    @Named(value="_muleLazyComponentInitializer")
    private LazyComponentInitializer lazyComponentInitializer;

    protected String getConfigFile() {
        return "custom-object-serializer-lazy-init.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    @Test
    @Issue(value="MULE-20012")
    @Description(value="Tests that the default object serializer gets correctly overridden whenever lazy initialization is run more than once")
    public void lazyInitPerformedTwice() {
        Location location = Location.builder().globalName(FIRST_LOCATION).build();
        this.lazyComponentInitializer.initializeComponent(location);
        MatcherAssert.assertThat((Object)muleContext.getObjectSerializer(), (Matcher)CoreMatchers.instanceOf(TestSerializationProtocol.class));
        location = Location.builder().globalName(SECOND_LOCATION).build();
        this.lazyComponentInitializer.initializeComponent(location);
        MatcherAssert.assertThat((Object)muleContext.getObjectSerializer(), (Matcher)CoreMatchers.instanceOf(TestSerializationProtocol.class));
    }

    public static class TestSerializationProtocol
    implements ObjectSerializer {
        public SerializationProtocol getInternalProtocol() {
            return null;
        }

        public SerializationProtocol getExternalProtocol() {
            return null;
        }
    }
}

