/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.transformers.simple;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.test.AbstractIntegrationTestCase;

public class SetPayloadDataTypeTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "set-payload-data-type-config.xml";
    }

    @Test
    public void setsPayloadLocal() throws Exception {
        this.assertPayloadMediaType("setPayload", MediaType.XML, StandardCharsets.UTF_16);
    }

    @Test
    public void setsPayloadLocalWithDefaultMediaType() throws Exception {
        this.assertPayloadMediaType("setPayloadWithDefaultMediaType", MediaType.ANY, null);
    }

    @Test
    public void setsPayloadLocalWithDW() throws Exception {
        this.assertPayloadMediaType("setPayloadWithDW", MediaType.XML, null);
    }

    @Test
    public void setsPayloadLocalWithDWsettingMediaType() throws Exception {
        Message response = this.getResponse("setPayloadWithDWsettingMediaType");
        MediaType JSON_UTF8 = MediaType.create((String)MediaType.JSON.getPrimaryType(), (String)MediaType.JSON.getSubType(), (Charset)StandardCharsets.UTF_8);
        DataType dataType = response.getPayload().getDataType();
        MatcherAssert.assertThat((Object)CursorStreamProvider.class.isAssignableFrom(dataType.getType()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)dataType.getMediaType(), (Matcher)Matchers.is((Object)JSON_UTF8));
    }

    private Message getResponse(String flowName) throws Exception {
        return ((FlowRunner)this.flowRunner(flowName).withPayload((Object)"Test Message")).run().getMessage();
    }

    private void assertPayloadMediaType(String flowName, MediaType expectedMediaType, Charset charset) throws Exception {
        Message response = this.getResponse(flowName);
        MatcherAssert.assertThat((Object)response.getPayload().getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)expectedMediaType, (Charset)charset));
    }
}

