/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.el;

import static org.mule.tck.junit4.matcher.IsEmptyOptional.empty;
import static org.mule.test.allure.AllureConstants.ExpressionLanguageFeature.EXPRESSION_LANGUAGE;

import static java.nio.charset.StandardCharsets.UTF_16;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

import java.nio.charset.Charset;
import java.util.Optional;

import org.apache.commons.io.IOUtils;
import org.junit.Rule;
import org.junit.Test;

import io.qameta.allure.Feature;

@Feature(EXPRESSION_LANGUAGE)
public class ExpressionLanguageEncodingTestCase extends AbstractIntegrationTestCase {

  @Rule
  public SystemProperty encoding = new SystemProperty("mule.encoding", UTF_16.displayName());

  @Override
  protected String getConfigFile() {
    return "org/mule/test/el/expression-language-encoding-config.xml";
  }

  @Test
  public void usesMuleEncoding() throws Exception {
    Message result = flowRunner("text").keepStreamsOpen().run().getMessage();
    Optional<Charset> charset = result.getPayload().getDataType().getMediaType().getCharset();
    assertThat(charset, not(empty()));
    assertThat(charset.get(), is(UTF_16));
    assertThat(IOUtils.toString(((CursorStreamProvider) result.getPayload().getValue()).openCursor(), UTF_16),
               is("This is evolution."));
  }
}
