/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.ApplicationContextBuilder;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MuleConfigurationConfigTestCase
extends AbstractMuleTestCase {
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private MuleContext muleContext;

    @After
    public void after() {
        if (this.muleContext != null) {
            this.muleContext.dispose();
        }
    }

    @Test
    public void configurationQueueTxLogSizeExplicitValue() throws Exception {
        this.muleContext = new WithServicesApplicationContextBuilder(this.testServicesConfigurationBuilder).setContextId(MuleConfigurationConfigTestCase.class.getSimpleName()).setApplicationResources(new String[]{"org/mule/test/config/configuration-queue-tx-log-size-explict-config.xml"}).build();
        Assert.assertThat((Object)this.muleContext.getConfiguration().getMaxQueueTransactionFilesSizeInMegabytes(), (Matcher)Is.is((Object)100));
    }

    @Test
    public void configurationQueueTxLogSizeDefaultValue() throws Exception {
        this.muleContext = new WithServicesApplicationContextBuilder(this.testServicesConfigurationBuilder).setContextId(MuleConfigurationConfigTestCase.class.getSimpleName()).setApplicationResources(new String[0]).build();
        Assert.assertThat((Object)this.muleContext.getConfiguration().getMaxQueueTransactionFilesSizeInMegabytes(), (Matcher)Is.is((Object)500));
    }

    private static class WithServicesApplicationContextBuilder
    extends ApplicationContextBuilder {
        private final TestServicesConfigurationBuilder testServicesConfigurationBuilder;

        public WithServicesApplicationContextBuilder(TestServicesConfigurationBuilder testServicesConfigurationBuilder) {
            this.testServicesConfigurationBuilder = testServicesConfigurationBuilder;
        }

        protected void addBuilders(List<ConfigurationBuilder> builders) {
            super.addBuilders(builders);
            builders.add((ConfigurationBuilder)this.testServicesConfigurationBuilder);
        }

        protected ConfigurationBuilder getAppBuilder(String[] configResource) throws Exception {
            ConfigurationBuilder appBuilder = super.getAppBuilder(configResource);
            appBuilder.addServiceConfigurator((ServiceConfigurator)this.testServicesConfigurationBuilder);
            return appBuilder;
        }
    }
}

