/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mule.functional.api.component.InvocationCountMessageProcessor;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Error Handling")
@Story(value="Error Handler")
public class TryAndErrorHandlingTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/try-error-handling.xml";
    }

    @Test
    @Description(value="Validates that try scope works within an error handler")
    public void tryInErrorHandler() throws Exception {
        CoreEvent event = this.flowRunner("tryInErrorHandler").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"hello"));
        MatcherAssert.assertThat((Object)InvocationCountMessageProcessor.getNumberOfInvocationsFor((String)"try-in-eh"), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void tryWithRecursiveOnErrorContinueInsideSubflow() throws Exception {
        this.flowRunner("tryWithRecursiveOnErrorContinueInsideSubflow").run();
        Message response = this.queueManager.read("dlq", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void tryWithRecursiveOnErrorContinueInsideFlow() throws Exception {
        this.flowRunner("tryWithRecursiveOnErrorContinueInsideFlow").run();
        Message response = this.queueManager.read("dlq", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
    }

    @Test
    @Issue(value="W-11861131")
    public void tryWithOnErrorHandlersComposition() throws Exception {
        this.flowRunner("tryWithOnErrorHandlersComposition").run();
    }
}

