/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.integration.locator.processor.CustomTestComponent;
import org.mule.tests.api.TestQueueManager;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public class LazyInitLifecycleTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("http.listener.port");
    @Rule
    public DynamicPort proxyPort = new DynamicPort("http.proxy.port");
    @Rule
    public SystemProperty path = new SystemProperty("path", "path");
    @Inject
    private Registry registry;
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;
    @Inject
    private TestQueueManager queueManager;

    protected String getConfigFile() {
        return "org/mule/test/integration/locator/component-locator-lifecycle-config.xml";
    }

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    @Description(value="Search for sub-flows with asyncs")
    @Test
    public void subFlowWithAsync() {
        CustomTestComponent.statesByInstances.clear();
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("async-flow").addProcessorsPart().addIndexPart(0).build());
        MatcherAssert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"async-flow").build()), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((String)CustomTestComponent.statesByInstances.toString(), (Object)CustomTestComponent.statesByInstances.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)CustomTestComponent.statesByInstances.toString(), CustomTestComponent.statesByInstances.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"initialized_started"}));
    }

    @Description(value="Initialize same sub-flow twice, test component should not fail when disposing")
    @Test
    public void lazyMuleContextInitializeMultipleTimesSubFlowWithUntilSuccessful() {
        CustomTestComponent.statesByInstances.clear();
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("untilSuccessfulFlow"));
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("untilSuccessfulFlowCopy"));
        muleContext.dispose();
        MatcherAssert.assertThat((Object)CustomTestComponent.statesByInstances.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(CustomTestComponent.statesByInstances.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"initialized_started_stopped_disposed", "initialized_started_stopped_disposed"}));
    }

    @Test
    @Ignore(value="MULE-18566")
    public void lazyMuleContextInitializeMultipleTimesProcessor() {
        CustomTestComponent.statesByInstances.clear();
        Location multipleInitiailizeProcessor1 = Location.builder().globalName("multipleInitialize").addProcessorsPart().addIndexPart(0).build();
        Location multipleInitiailizeProcessor2 = Location.builder().globalName("multipleInitialize").addProcessorsPart().addIndexPart(1).build();
        this.lazyComponentInitializer.initializeComponent(multipleInitiailizeProcessor1);
        MatcherAssert.assertThat((Object)this.locator.find(multipleInitiailizeProcessor1), (Matcher)Matchers.not(Optional.empty()));
        MatcherAssert.assertThat((Object)this.locator.find(multipleInitiailizeProcessor2), (Matcher)Matchers.is(Optional.empty()));
        MuleConfiguration configuration = (MuleConfiguration)this.registry.lookupByType(MuleConfiguration.class).orElseThrow(() -> new AssertionError((Object)"Missing MuleConfiguration from registry"));
        this.lazyComponentInitializer.initializeComponent(multipleInitiailizeProcessor2);
        MatcherAssert.assertThat((Object)this.locator.find(multipleInitiailizeProcessor1), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)this.locator.find(multipleInitiailizeProcessor2), (Matcher)Matchers.not(Optional.empty()));
        MuleConfiguration afterNextInitConfiguration = (MuleConfiguration)this.registry.lookupByType(MuleConfiguration.class).orElseThrow(() -> new AssertionError((Object)"Missing MuleConfiguration from registry"));
        MatcherAssert.assertThat((Object)configuration, (Matcher)Matchers.sameInstance((Object)afterNextInitConfiguration));
        MatcherAssert.assertThat((Object)configuration, (Matcher)Matchers.equalTo((Object)afterNextInitConfiguration));
        muleContext.dispose();
        MatcherAssert.assertThat((Object)CustomTestComponent.statesByInstances.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(CustomTestComponent.statesByInstances.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"initialized_started_stopped_disposed", "initialized_started_stopped_disposed"}));
    }

    @Test
    public void shouldNotCreateBeansForSameLocationRequest() {
        CustomTestComponent.statesByInstances.clear();
        Location location = Location.builderFromStringRepresentation((String)"untilSuccessfulFlow").build();
        this.lazyComponentInitializer.initializeComponent(location);
        this.lazyComponentInitializer.initializeComponent(location);
        muleContext.dispose();
        MatcherAssert.assertThat((Object)CustomTestComponent.statesByInstances.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(CustomTestComponent.statesByInstances.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"initialized_started_stopped_disposed"}));
    }

    @Test
    public void shouldNotCreateBeansForSameLocationFilterRequest() {
        CustomTestComponent.statesByInstances.clear();
        LazyComponentInitializer.ComponentLocationFilter componentLocationFilter = componentLocation -> componentLocation.getLocation().equals("untilSuccessfulFlow");
        this.lazyComponentInitializer.initializeComponents(componentLocationFilter);
        this.lazyComponentInitializer.initializeComponents(componentLocationFilter);
        muleContext.dispose();
        MatcherAssert.assertThat((Object)CustomTestComponent.statesByInstances.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(CustomTestComponent.statesByInstances.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"initialized_started_stopped_disposed"}));
    }

    @Test
    public void globalMuleConfigurationDefaultResponseTimeout() {
        CustomTestComponent.statesByInstances.clear();
        MuleConfiguration configuration = (MuleConfiguration)this.registry.lookupByType(MuleConfiguration.class).orElseThrow(() -> new AssertionError((Object)"Missing MuleConfiguration from registry"));
        MatcherAssert.assertThat((Object)configuration.getDefaultResponseTimeout(), (Matcher)Matchers.is((Object)10000));
        MatcherAssert.assertThat((String)CustomTestComponent.statesByInstances.toString(), (Object)CustomTestComponent.statesByInstances.size(), (Matcher)Matchers.is((Object)0));
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowFailing").build());
        configuration = (MuleConfiguration)this.registry.lookupByType(MuleConfiguration.class).orElseThrow(() -> new AssertionError((Object)"Missing MuleConfiguration from registry"));
        MatcherAssert.assertThat((Object)configuration.getDefaultResponseTimeout(), (Matcher)Matchers.is((Object)2001));
        muleContext.dispose();
        MatcherAssert.assertThat((String)CustomTestComponent.statesByInstances.toString(), (Object)CustomTestComponent.statesByInstances.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)CustomTestComponent.statesByInstances.toString(), CustomTestComponent.statesByInstances.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"initialized_started_stopped_disposed"}));
    }

    @Test
    public void globalErrorHandlerApplied() throws Exception {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowFailing").build());
        this.flowRunner("flowFailing").runExpectingException();
        MatcherAssert.assertThat((Object)this.queueManager.read("globalErrorHandlerQueue", 5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

