/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Routers")
@Story(value="Parallel For Each")
public class ParallelForEachWithContextScopesTestCase
extends AbstractIntegrationTestCase {
    private static final int PROBER_POLLING_INTERVAL = 100;
    private static final int PROBER_POLLING_TIMEOUT = 5000;
    private static final String[] FRUIT_LIST = new String[]{"apple", "banana", "orange"};
    private static final Set<PhantomReference<CoreEvent>> eventRefs = new HashSet<PhantomReference<CoreEvent>>();

    @Before
    public void before() {
        eventRefs.clear();
    }

    protected String getConfigFile() {
        return "routers/parallel-for-each-context-scopes.xml";
    }

    @Test
    @Issue(value="MULE-18696")
    @Description(value="Check that parallel for each is not referencing to the original event prior the error handling")
    public void parallelForEachWithErrorHandling() throws Exception {
        ((FlowRunner)this.flowRunner("parallelForEachWithErrorHandling").withPayload((Object)FRUIT_LIST)).run();
        ParallelForEachWithContextScopesTestCase.assertEventsUnreferenced();
    }

    private static void assertEventsUnreferenced() {
        new PollingProber(5000L, 100L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                System.gc();
                for (PhantomReference<CoreEvent> phantomReference : eventRefs) {
                    Assert.assertThat((Object)phantomReference.isEnqueued(), (Matcher)CoreMatchers.is((Object)true));
                }
                return true;
            }
        });
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    public static class EventReferenceProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            Set<PhantomReference<CoreEvent>> set = eventRefs;
            synchronized (set) {
                if (eventRefs.size() > 0) {
                    ParallelForEachWithContextScopesTestCase.assertEventsUnreferenced();
                }
                eventRefs.add(new PhantomReference<PrivilegedEvent>(PrivilegedEvent.getCurrentEvent(), new ReferenceQueue()));
            }
            return event;
        }
    }
}

