/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.service.scheduler;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerBusyException;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Scheduler Service")
public class SchedulerServiceTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return "org/mule/test/service/scheduler/scheduler-service.xml";
    }

    @Test
    @Description(value="Test that the scheduler service is properly injected into a Mule component")
    public void useSchedulingService() throws Exception {
        this.flowRunner("willSchedule").run();
    }

    @Test
    public void schedulerDefaultName() {
        SchedulerService schedulerService = muleContext.getSchedulerService();
        Scheduler ioScheduler = schedulerService.ioScheduler();
        MatcherAssert.assertThat((Object)ioScheduler.getName(), (Matcher)CoreMatchers.startsWith((String)("[SchedulerServiceTestCase#schedulerDefaultName].uber@" + SchedulerServiceTestCase.class.getName() + ".schedulerDefaultName:")));
        ioScheduler.shutdownNow();
    }

    @Test
    public void customSchedulerDefaultName() {
        SchedulerService schedulerService = muleContext.getSchedulerService();
        Scheduler ioScheduler = schedulerService.customScheduler(muleContext.getSchedulerBaseConfig().withMaxConcurrentTasks(1));
        MatcherAssert.assertThat((Object)ioScheduler.getName(), (Matcher)CoreMatchers.startsWith((String)("[SchedulerServiceTestCase#customSchedulerDefaultName].custom@" + SchedulerServiceTestCase.class.getName() + ".customSchedulerDefaultName:")));
        ioScheduler.shutdownNow();
    }

    @Test
    public void schedulerCustomName() {
        SchedulerService schedulerService = muleContext.getSchedulerService();
        Scheduler ioScheduler = schedulerService.ioScheduler(muleContext.getSchedulerBaseConfig().withName("myPreciousScheduler"));
        MatcherAssert.assertThat((Object)ioScheduler.getName(), (Matcher)CoreMatchers.startsWith((String)"[SchedulerServiceTestCase#schedulerCustomName].myPreciousScheduler"));
        ioScheduler.shutdownNow();
    }

    @Test
    public void configTimeoutChange() {
        Scheduler scheduler = muleContext.getSchedulerService().cpuLightScheduler();
        Latch testLatch = new Latch();
        scheduler.submit(() -> {
            try {
                testLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        long stopRequestTime = System.currentTimeMillis();
        scheduler.stop();
        MatcherAssert.assertThat((String)"gracefultShutdown flag in test not honored", (Object)muleContext.getConfiguration().getShutdownTimeout(), (Matcher)Is.is((Object)10L));
        MatcherAssert.assertThat((Object)(System.currentTimeMillis() - stopRequestTime), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(1000L)));
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add((ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                ((DefaultMuleConfiguration)muleContext.getConfiguration()).setShutdownTimeout(10000L);
            }
        });
    }

    @Test
    @Description(value="Tests that the exception that happens when a thread pool is full is properly handled.")
    public void overloadErrorHandling() throws Exception {
        this.expectedError.expectErrorType(Matchers.any(String.class), Is.is((Object)"OVERLOAD"));
        this.expectedError.expectCause(CoreMatchers.instanceOf(RejectedExecutionException.class));
        this.flowRunner("delaySchedule").run();
    }

    @Test
    @Description(value="Tests that an OVERLOAD error is handled only by the message source. This assumes org.mule.test.integration.exceptions.ErrorHandlerTestCase#criticalNotHandled")
    public void overloadErrorHandlingFromSource() throws Throwable {
        MessageSource messageSource = (MessageSource)this.locator.find(Location.builderFromStringRepresentation((String)"delaySchedule/source").build()).get();
        this.expectedError.expectErrorType("MULE", "OVERLOAD");
        this.expectedError.expectCause(CoreMatchers.instanceOf(RejectedExecutionException.class));
        Field messageProcessorField = messageSource.getClass().getDeclaredField("messageProcessor");
        messageProcessorField.setAccessible(true);
        Processor listener = (Processor)messageProcessorField.get(messageSource);
        listener.process(CoreEvent.builder((EventContext)EventContextFactory.create((String)"id", (String)"serverd", (ComponentLocation)DefaultComponentLocation.from((String)SchedulerServiceTestCase.class.getSimpleName()), null, Optional.empty())).message(Message.of(null)).build());
    }

    @Test
    @Description(value="Test that the name of a thread executing a processor has excution context information about its flow")
    public void flowProcessingThreadName() throws Exception {
        this.flowRunner("willSchedule").run();
        MatcherAssert.assertThat((Object)RecordThreadName.threadName, (Matcher)Matchers.allOf((Matcher)CoreMatchers.startsWith((String)"[MuleRuntime].uber."), (Matcher)Matchers.containsString((String)"[SchedulerServiceTestCase#flowProcessingThreadName].willSchedule.CPU_LITE @")));
    }

    public static class RecordThreadName
    implements Processor {
        public static String threadName;

        public CoreEvent process(CoreEvent event) throws MuleException {
            threadName = Thread.currentThread().getName();
            return event;
        }
    }

    public static class RaiseBusy
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new SchedulerBusyException("JustToBeAbleToInstantiateException");
        }
    }

    public static class HasSchedulingService
    implements Processor,
    Initialisable,
    Disposable {
        @Inject
        private SchedulerService schedulerService;
        private Scheduler scheduler;

        public void initialise() throws InitialisationException {
            if (this.scheduler == null) {
                this.scheduler = this.schedulerService.cpuLightScheduler();
            }
        }

        public void dispose() {
            this.scheduler.shutdownNow();
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            try {
                return (CoreEvent)this.scheduler.submit(() -> event).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return event;
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException(e.getCause());
            }
        }
    }
}

