/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.context.notification;

import static java.util.Arrays.asList;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsString;

import static org.junit.jupiter.api.Assertions.assertThrows;

import org.mule.test.config.spring.parsers.AbstractBadConfigTestCase;
import org.mule.test.runner.RunnerDelegateTo;

import java.util.Collection;

import org.hamcrest.Matcher;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

@RunnerDelegateTo(Parameterized.class)
public class NotificationTypesTestCase extends AbstractBadConfigTestCase {

  @Parameters(name = "{0}")
  public static Collection<Object[]> data() {
    return asList(new Object[][] {
        {"org/mule/test/context/notification/mule-config-inexistent-notification.xml",
            containsString("No notification 'nothing:I-DONT-EXIST' declared in this applications plugins to enable.")},

        {"org/mule/test/context/notification/mule-config-disable-inexistent-notification.xml",
            containsString("No notification 'nothing:I-DONT-EXIST' declared in this applications plugins to disable.")},

        {"org/mule/test/context/notification/mule-config-invalid-notification.xml",
            containsString("'1234' is not a valid value of union type 'notificationTypes'")},

        {"org/mule/test/context/notification/mule-config-disable-invalid-notification.xml",
            containsString("'1234' is not a valid value of union type 'notificationTypes'")}
    });
  }

  private Matcher<String> parseConfigErrorMessageMatcher;

  private String configFile;

  public NotificationTypesTestCase(String configFile, Matcher<String> parseConfigErrorMessageMatcher) {
    this.configFile = configFile;
    this.parseConfigErrorMessageMatcher = parseConfigErrorMessageMatcher;
  }

  @Override
  protected String getConfigFile() {
    return configFile;
  }

  @Test
  public void failingNotificationType() {
    var thrown = assertThrows(Exception.class, () -> parseConfig());
    assertThat(thrown.getMessage(), parseConfigErrorMessageMatcher);
  }
}
