/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.lifecycle.LifecycleStateEnabled;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class FlowStateTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty initialState = new SystemProperty("state", "started");

    protected String getConfigFile() {
        return "org/mule/test/components/flow-initial-state.xml";
    }

    @Test
    public void testDefaultInitialState() throws Exception {
        this.doTestStarted("default");
    }

    @Test
    public void testStartedInitialState() throws Exception {
        this.doTestStarted("started");
    }

    @Test
    public void testPlaceholderStartedInitialState() throws Exception {
        this.doTestStarted("placeholder");
    }

    protected void doTestStarted(String flowName) throws Exception {
        Flow flow = (Flow)this.registry.lookupByName(flowName + "Flow").get();
        this.assertStarted(flow);
        Assert.assertTrue((boolean)((LifecycleStateEnabled)this.locator.find(Location.builderFromStringRepresentation((String)(flowName + "Flow/source")).build()).get()).getLifecycleState().isStarted());
    }

    @Test
    public void testInitialStateStopped() throws Exception {
        Flow flow = (Flow)this.registry.lookupByName("stoppedFlow").get();
        this.assertStopped(flow);
        LifecycleStateEnabled source = (LifecycleStateEnabled)this.locator.find(Location.builderFromStringRepresentation((String)"stoppedFlow/source").build()).get();
        Assert.assertFalse((boolean)source.getLifecycleState().isStarted());
        ((Startable)this.registry.lookupByName("stoppedFlow").get()).start();
        this.assertStarted(flow);
        Assert.assertTrue((boolean)source.getLifecycleState().isStarted());
    }

    @Test
    @Issue(value="MULE-18059")
    @Description(value="Make sure that the `initialState` flag in a flow is honored when restarting the app.")
    public void appResetKeepsFlowInitialState() throws Exception {
        Flow flow = (Flow)this.registry.lookupByName("stoppedFlow").get();
        this.assertStopped(flow);
        muleContext.stop();
        muleContext.start();
        this.assertStopped(flow);
    }

    private void assertStarted(Flow flow) {
        Assert.assertTrue((boolean)flow.getLifecycleState().isStarted());
        Assert.assertFalse((boolean)flow.getLifecycleState().isStopped());
        Assert.assertTrue((boolean)flow.isStarted());
        Assert.assertFalse((boolean)flow.isStopped());
    }

    private void assertStopped(Flow flow) {
        Assert.assertFalse((boolean)flow.getLifecycleState().isStarted());
        Assert.assertTrue((boolean)flow.getLifecycleState().isStopped());
        Assert.assertFalse((boolean)flow.isStarted());
        Assert.assertTrue((boolean)flow.isStopped());
    }
}

