/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
public class ConfigurationPropertiesTestCase
extends AbstractIntegrationTestCase {
    @ClassRule
    public static SystemProperty globalPropertySystemProperty = new SystemProperty("globalPropertyValue", "global-property-value");
    @Inject
    private ConfigurationProperties configurationProperties;

    protected String getConfigFile() {
        return "org/mule/test/components/configuration-properties-config.xml";
    }

    @Description(value="Defines a configuration-properties with a file attribute that has a placeholder which value is provided by a global property")
    @Test
    public void configurationFileWithPlaceholdersDefinedWithGlobalProperty() {
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("myProp").get()), (Matcher)Is.is((Object)"myEnvValue"));
    }

    @Description(value="Defines several scenarios of properties values which contains placeholders that needs to be resolved between global-property elements and configuration-properties files")
    @Test
    public void expandPropertiesWithOtherProperties() {
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("complexValue").get()), (Matcher)Is.is((Object)"value2-value1"));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("anotherComplexValue").get()), (Matcher)Is.is((Object)"value1-filePropValue"));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("http.path").get()), (Matcher)Is.is((Object)"myEnvValue"));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("http.url").get()), (Matcher)Is.is((Object)"http://localhost/myEnvValue"));
    }

    @Description(value="Configuration properties file attribute value using placeholder pointing to global property that is configured using a system property")
    @Test
    public void configPropertiesFileFromGlobalPropertyWithSystemPropertyValue() {
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("global.property.value.key").get()), (Matcher)Is.is((Object)"globalPropertyValueKeyValue"));
    }

    @Description(value="Configuration properties can escape the placeholder prefix")
    @Test
    public void prefixCanBeEscaped() {
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty("escaped").get()), (Matcher)Is.is((Object)"This is ${ escaped myEnvValue"));
    }
}

