/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import jakarta.inject.Inject;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

public class PropertiesHierarchyTestCase
extends AbstractIntegrationTestCase {
    private static final String DEPLOYMENT_PROPERTIES_HIGHER_HIERARCHY = "Deployment wins";
    private static final String SYSTEM_PROPERTIES_HIGHER_HIERARCHY = "System wins";
    private static final String APPLICATION_PROPERTIES_HIGHER_HIERARCHY = "App wins";
    private static final String GLOBAL_PLUS_APP = "Global - App";
    private static final String GLOBAL_PLUS_SYSTEM = "Global - System";
    private static final String GLOBAL_PLUS_APP_PLUS_SYSTEM = "Global - App - System";
    private static final String APP_PLUS_GLOBAL = "App - Global";
    private static final String APP_PLUS_SYSTEM = "App - System";
    private static final String APP_PLUS_SYSTEM_VS_GLOBAL = "App - System wins";
    private static final String SYSTEM_PLUS_APP = "System - App";
    private static final String SYSTEM_PLUS_GLOBAL = "System - Global";
    private static final String DEPLOYMENT_VS_SYSTEM = "deploymentVsSystem";
    private static final String SYSTEM_VS_APP = "systemVsApp";
    private static final String SYSTEM_VS_GLOBAL = "systemVsGlobal";
    private static final String APP_VS_GLOBAL = "appVsGlobal";
    private static final String DEPLOYMENT_VS_GLOBAL = "deploymentVsGlobal";
    private static final String DEPLOYMENT_VS_APP = "deploymentVsApp";
    private static final String GLOBAL_DEP_APP = "globalDepApp";
    private static final String GLOBAL_DEP_SYSTEM = "globalDepSystem";
    private static final String APP_DEP_GLOBAL = "appDepGlobal";
    private static final String APP_DEP_SYSTEM = "appDepSystem";
    private static final String SYSTEM_DEP_APP = "systemDepApp";
    private static final String SYSTEM_DEP_GLOBAL = "systemDepGlobal";
    private static final String GLOBAL_DEP_APP_DEP_SYSTEM = "globalDepAppDepSystem";
    private static final String APP_WITH_OVERRIDED_DEPENDENCY = "appDepOverriden";
    @Inject
    private ConfigurationProperties configurationProperties;
    @Rule
    public SystemProperty deploymentVsSystem = new SystemProperty("deploymentVsSystem", "System wins");
    @Rule
    public SystemProperty systemVsApp = new SystemProperty("systemVsApp", "System wins");
    @Rule
    public SystemProperty systemVsGlobal = new SystemProperty("systemVsGlobal", "System wins");
    @Rule
    public SystemProperty systemValue = new SystemProperty("systemValue", "System");
    @Rule
    public SystemProperty systemDepApp = new SystemProperty("systemDepApp", this.systemValue.getValue() + " - ${appValue}");
    @Rule
    public SystemProperty systemDepGlobal = new SystemProperty("systemDepGlobal", this.systemValue.getValue() + " - ${globalValue}");

    protected String getConfigFile() {
        return "org/mule/test/components/properties-hierarchy-config.xml";
    }

    protected Map<String, String> artifactProperties() {
        return Map.of(DEPLOYMENT_VS_SYSTEM, DEPLOYMENT_PROPERTIES_HIGHER_HIERARCHY, DEPLOYMENT_VS_APP, DEPLOYMENT_PROPERTIES_HIGHER_HIERARCHY, DEPLOYMENT_VS_GLOBAL, DEPLOYMENT_PROPERTIES_HIGHER_HIERARCHY);
    }

    @Test
    public void deploymentPropertiesHavePrecedenceOverSystemProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(DEPLOYMENT_VS_SYSTEM).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(DEPLOYMENT_VS_SYSTEM).get()), (Matcher)CoreMatchers.is((Object)DEPLOYMENT_PROPERTIES_HIGHER_HIERARCHY));
    }

    @Test
    public void deploymentPropertiesHavePrecedenceOverApplicationProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(DEPLOYMENT_VS_APP).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(DEPLOYMENT_VS_APP).get()), (Matcher)CoreMatchers.is((Object)DEPLOYMENT_PROPERTIES_HIGHER_HIERARCHY));
    }

    @Test
    public void deploymentPropertiesHavePrecedenceOverGlobalProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(DEPLOYMENT_VS_GLOBAL).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(DEPLOYMENT_VS_GLOBAL).get()), (Matcher)CoreMatchers.is((Object)DEPLOYMENT_PROPERTIES_HIGHER_HIERARCHY));
    }

    @Test
    public void systemPropertiesHavePrecedenceOverApplicationProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(SYSTEM_VS_APP).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(SYSTEM_VS_APP).get()), (Matcher)CoreMatchers.is((Object)SYSTEM_PROPERTIES_HIGHER_HIERARCHY));
    }

    @Test
    public void systemPropertiesHavePrecedenceOverGlobalProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(SYSTEM_VS_GLOBAL).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(SYSTEM_VS_GLOBAL).get()), (Matcher)CoreMatchers.is((Object)SYSTEM_PROPERTIES_HIGHER_HIERARCHY));
    }

    @Test
    public void applicationPropertiesHavePrecedenceOverGlobalProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(APP_VS_GLOBAL).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(APP_VS_GLOBAL).get()), (Matcher)CoreMatchers.is((Object)APPLICATION_PROPERTIES_HIGHER_HIERARCHY));
    }

    @Test
    public void globalPropertiesCanDependOnApplicationProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(GLOBAL_DEP_APP).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(GLOBAL_DEP_APP).get()), (Matcher)CoreMatchers.is((Object)GLOBAL_PLUS_APP));
    }

    @Test
    public void applicationPropertiesCanDependOnGlobalProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(APP_DEP_GLOBAL).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(APP_DEP_GLOBAL).get()), (Matcher)CoreMatchers.is((Object)APP_PLUS_GLOBAL));
    }

    @Test
    public void globalPropertiesCanDependOnSystemProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(GLOBAL_DEP_SYSTEM).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(GLOBAL_DEP_SYSTEM).get()), (Matcher)CoreMatchers.is((Object)GLOBAL_PLUS_SYSTEM));
    }

    @Test
    public void systemPropertiesCanDependOnGlobalProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(SYSTEM_DEP_GLOBAL).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(SYSTEM_DEP_GLOBAL).get()), (Matcher)CoreMatchers.is((Object)SYSTEM_PLUS_GLOBAL));
    }

    @Test
    public void applicationPropertiesCanDependOnSystemProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(APP_DEP_SYSTEM).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(APP_DEP_SYSTEM).get()), (Matcher)CoreMatchers.is((Object)APP_PLUS_SYSTEM));
    }

    @Test
    public void systemPropertiesCanDependOnApplicationProperties() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(SYSTEM_DEP_APP).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(SYSTEM_DEP_APP).get()), (Matcher)CoreMatchers.is((Object)SYSTEM_PLUS_APP));
    }

    @Test
    public void globalPropertyDependsOnAppPropertyWhichDependsOnSystemProperty() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(GLOBAL_DEP_APP_DEP_SYSTEM).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(GLOBAL_DEP_APP_DEP_SYSTEM).get()), (Matcher)CoreMatchers.is((Object)GLOBAL_PLUS_APP_PLUS_SYSTEM));
    }

    @Test
    public void applicationPropertyCanDependOnPropertyWithOverridenValue() {
        MatcherAssert.assertThat((Object)this.configurationProperties.resolveStringProperty(APP_WITH_OVERRIDED_DEPENDENCY).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)this.configurationProperties.resolveStringProperty(APP_WITH_OVERRIDED_DEPENDENCY).get()), (Matcher)CoreMatchers.is((Object)APP_PLUS_SYSTEM_VS_GLOBAL));
    }
}

