/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import org.apache.http.HttpResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.TlsTestUtils;
import org.mule.tls.fips.DefaultTestConfiguration;
import org.mule.tls.matcher.HttpResponseContentStringMatcher;
import org.mule.tls.matcher.HttpResponseStatusCodeMatcher;

@Feature(value="TLS/SSL")
public class TlsContextCustomProtocolsTestCase
extends AbstractIntegrationTestCase {
    @ClassRule
    public static final DynamicPort httpsPort = new DynamicPort("httpsPort");
    @ClassRule
    public static final DynamicPort httpsInternalDefaultPort = new DynamicPort("https.internal.default");
    @ClassRule
    public static final DynamicPort httpsInternalTls11Port = new DynamicPort("https.internal.tlsv11");
    @ClassRule
    public static final DynamicPort httpsInternalTls12Port = new DynamicPort("https.internal.tlsv12");
    @ClassRule
    public static final DynamicPort httpsInternalAllTlsPort = new DynamicPort("https.internal.alltls");
    @ClassRule
    public static SystemProperty enabledProtocols = new SystemProperty("enabledProtocols", "TLSv1.2");
    @ClassRule
    public static SystemProperty verboseExceptions = new SystemProperty("mule.verbose.exceptions", "true");
    private static final String urlPrefix = "https://localhost:" + httpsPort.getValue();
    private static final String defaultProtocolsPassUrl = urlPrefix + "/test/defaultPass";
    private static final String defaultProtocolsFailsUrl = urlPrefix + "/test/defaultFails";
    private static final String customInvalidProtocolsUrl = urlPrefix + "/test/customInvalid";
    private static final String customValidProtocolsUrl = urlPrefix + "/test/customValid";
    private static final String customProtocolsPropertyUrl = urlPrefix + "/test/property";
    private static final String OK_RESPONSE = "ok";
    private static final String ERROR_RESPONSE = "failed";
    @ClassRule
    public static final SystemProperty sslCacerts = new SystemProperty("sslTestTrustStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslCaCerts());
    @ClassRule
    public static final SystemProperty sslKeyStore = new SystemProperty("sslTestKeyStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslKeyStore());
    @ClassRule
    public static final SystemProperty storeType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    @ClassRule
    public static final SystemProperty password = new SystemProperty("password", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().resolveStorePassword("changeit"));

    protected String getConfigFile() {
        return "tls-protocols-config.xml";
    }

    @Test
    public void testGlobalTlsContextDefaultProtocolsPass() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(defaultProtocolsPassUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(200));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)CoreMatchers.is((Object)OK_RESPONSE)));
    }

    @Test
    public void testGlobalTlsContextDefaultProtocolsFails() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(defaultProtocolsFailsUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(200));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)CoreMatchers.is((Object)OK_RESPONSE)));
    }

    @Test
    public void testGlobalTlsContextCustomProtocolsRestrictive() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(customInvalidProtocolsUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(500));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)CoreMatchers.containsString((String)ERROR_RESPONSE)));
    }

    @Test
    public void testGlobalTlsContextCustomProtocolsWider() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(customValidProtocolsUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(200));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)CoreMatchers.is((Object)OK_RESPONSE)));
    }

    @Test
    public void testGlobalTlsContextCustomProtocolsProperty() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(customProtocolsPropertyUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(200));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)CoreMatchers.is((Object)OK_RESPONSE)));
    }
}

