/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.junit4.DomainFunctionalTestCase;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.test.petstore.extension.PetStoreConnector;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public class LazyInitComponentWithParentArtifactTestCase
extends DomainFunctionalTestCase {
    private static final String APP_NAME = "app-depending-on-parent-config";
    private LazyComponentInitializer appLazyComponentInitializer;
    private LazyComponentInitializer domainLazyComponentInitializer;
    private ConfigurationComponentLocator appLocator;
    private ConfigurationComponentLocator domainLocator;

    protected boolean enableLazyInit() {
        return true;
    }

    protected boolean disableXmlValidations() {
        return true;
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig(APP_NAME, new String[]{"org/mule/test/integration/locator/component-locator-depending-on-parent-config.xml"})};
    }

    protected String[] getDomainConfigs() {
        return new String[]{"org/mule/test/integration/locator/domain-with-http-config.xml"};
    }

    protected Set<ExtensionModel> getExtensionModels() {
        return Set.of(MuleExtensionModelProvider.getExtensionModel(), LazyInitComponentWithParentArtifactTestCase.loadJavaSdkExtension(PetStoreConnector.class, ((Object)((Object)this)).getClass().getClassLoader(), Collections.emptySet()));
    }

    @Before
    public void grabObjectsFromArtifactsInfrastructure() {
        this.appLazyComponentInitializer = this.getLazyComponentInitializerForApp(APP_NAME);
        this.domainLazyComponentInitializer = this.getLazyComponentInitializerForDomain();
        this.appLocator = this.getLocatorForApp(APP_NAME);
        this.domainLocator = this.getLocatorForDomain();
    }

    @Test
    public void whenInitializingComponentsDependingOnComponentInParentArtifactThenComponentsThatAreNotReferencedAreNotInitialized() {
        this.appLazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"flowDependingOnConfigFromDomain").build());
        this.assertLocationsNotInitialized(this.domainLocator, "anotherConfigThatShouldNotBeInitialized");
    }

    @Test
    public void whenInitializingComponentsDependingOnComponentInParentArtifactThenBothAreInitialized() {
        this.appLazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"flowDependingOnConfigFromDomain").build());
        this.assertFlowsInitialized(this.appLocator, "flowDependingOnConfigFromDomain");
        this.assertLocationsInitialized(this.appLocator, "flowDependingOnConfigFromDomain", "flowDependingOnConfigFromDomain/source");
        this.assertLocationsNotInitialized(this.appLocator, "anotherFlowThatShouldNotBeInitialized");
        this.assertLocationsInitialized(this.domainLocator, "configInDomain");
        this.assertLocationsNotInitialized(this.domainLocator, "anotherConfigThatShouldNotBeInitialized");
    }

    @Test
    public void whenInitializingTwoComponentsDependingOnComponentInParentArtifactThenSecondAreInitialized() {
        this.appLazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"anotherFlowDependingOnAnotherConfigFromDomain").build());
        this.assertLocationsInitialized(this.appLocator, "anotherFlowDependingOnAnotherConfigFromDomain", "anotherFlowDependingOnAnotherConfigFromDomain/source");
        this.assertLocationsNotInitialized(this.appLocator, "flowDependingOnConfigFromDomain");
        this.assertLocationsInitialized(this.domainLocator, "anotherConfigInDomain");
        this.appLazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"flowDependingOnConfigFromDomain").build());
        this.assertFlowsInitialized(this.appLocator, "flowDependingOnConfigFromDomain");
        this.assertLocationsInitialized(this.appLocator, "flowDependingOnConfigFromDomain", "flowDependingOnConfigFromDomain/source");
        this.assertLocationsNotInitialized(this.appLocator, "anotherFlowDependingOnAnotherConfigFromDomain", "anotherFlowDependingOnAnotherConfigFromDomain/source");
        this.assertLocationsNotInitialized(this.appLocator, "anotherFlowThatShouldNotBeInitialized");
        this.assertLocationsInitialized(this.domainLocator, "configInDomain");
        this.assertLocationsNotInitialized(this.domainLocator, "anotherConfigThatShouldNotBeInitialized");
    }

    @Test
    public void whenInitializingAdditionalComponentsDependingOnComponentInParentArtifactThenBothAreInitialized() {
        this.appLazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"anotherFlowDependingOnAnotherConfigFromDomain").build());
        this.assertLocationsInitialized(this.appLocator, "anotherFlowDependingOnAnotherConfigFromDomain", "anotherFlowDependingOnAnotherConfigFromDomain/source");
        this.assertLocationsNotInitialized(this.appLocator, "flowDependingOnConfigFromDomain");
        this.getInfrastructureForApp(APP_NAME).getRegistry().lookupByName("flowDependingOnConfigFromDomain");
        this.assertFlowsInitialized(this.appLocator, "anotherFlowDependingOnAnotherConfigFromDomain", "flowDependingOnConfigFromDomain");
        this.assertLocationsInitialized(this.appLocator, "anotherFlowDependingOnAnotherConfigFromDomain", "anotherFlowDependingOnAnotherConfigFromDomain/source");
        this.assertLocationsInitialized(this.appLocator, "flowDependingOnConfigFromDomain", "flowDependingOnConfigFromDomain/source");
        this.assertLocationsNotInitialized(this.appLocator, "anotherFlowThatShouldNotBeInitialized");
        this.assertLocationsInitialized(this.domainLocator, "configInDomain");
        this.assertLocationsInitialized(this.domainLocator, "anotherConfigInDomain");
        this.assertLocationsNotInitialized(this.domainLocator, "anotherConfigThatShouldNotBeInitialized");
    }

    @Test
    @Issue(value="W-13917141")
    public void whenCreatingArtifactContextWithAlreadyInitializedParentArtifactThenItDoesntFail() throws Exception {
        this.domainLazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"configInDomain").build());
        DomainFunctionalTestCase.ArtifactInstanceInfrastructure artifactInstanceInfrastructure = this.createAppMuleContext(this.getConfigResources()[0]);
        LazyComponentInitializer appLazyComponentInitializer = this.getLazyComponentInitializerFromArtifactInfrastructure(artifactInstanceInfrastructure);
        ConfigurationComponentLocator appLocator = this.getLocatorFromArtifactInfrastructure(artifactInstanceInfrastructure);
        appLazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"anotherFlowDependingOnAnotherConfigFromDomain").build());
        this.assertFlowsInitialized(appLocator, "anotherFlowDependingOnAnotherConfigFromDomain");
        this.assertLocationsInitialized(appLocator, "anotherFlowDependingOnAnotherConfigFromDomain", "anotherFlowDependingOnAnotherConfigFromDomain/source");
        this.assertLocationsNotInitialized(appLocator, "anotherFlowThatShouldNotBeInitialized");
        this.assertLocationsInitialized(this.domainLocator, "configInDomain");
        this.assertLocationsInitialized(this.domainLocator, "anotherConfigInDomain");
        this.assertLocationsNotInitialized(this.domainLocator, "anotherConfigThatShouldNotBeInitialized");
        artifactInstanceInfrastructure.getMuleContext().dispose();
    }

    private LazyComponentInitializer getLazyComponentInitializerForApp(String appName) {
        return this.getLazyComponentInitializerFromArtifactInfrastructure(this.getInfrastructureForApp(appName));
    }

    private LazyComponentInitializer getLazyComponentInitializerForDomain() {
        return this.getLazyComponentInitializerFromArtifactInfrastructure(this.getDomainInfrastructure());
    }

    private ConfigurationComponentLocator getLocatorForApp(String appName) {
        return this.getLocatorFromArtifactInfrastructure(this.getInfrastructureForApp(appName));
    }

    private ConfigurationComponentLocator getLocatorForDomain() {
        return this.getLocatorFromArtifactInfrastructure(this.getDomainInfrastructure());
    }

    private LazyComponentInitializer getLazyComponentInitializerFromArtifactInfrastructure(DomainFunctionalTestCase.ArtifactInstanceInfrastructure infrastructure) {
        return (LazyComponentInitializer)infrastructure.getRegistry().lookupByType(LazyComponentInitializer.class).get();
    }

    private ConfigurationComponentLocator getLocatorFromArtifactInfrastructure(DomainFunctionalTestCase.ArtifactInstanceInfrastructure infrastructure) {
        return (ConfigurationComponentLocator)infrastructure.getRegistry().lookupByType(ConfigurationComponentLocator.class).get();
    }

    private void assertFlowsInitialized(ConfigurationComponentLocator locator, String ... expectedFlowNames) {
        List flowNames = locator.find(ComponentIdentifier.buildFromStringRepresentation((String)"flow")).stream().map(c -> ((NamedObject)c).getName()).collect(Collectors.toList());
        Assert.assertThat(flowNames, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFlowNames));
    }

    private void assertLocationsInitialized(ConfigurationComponentLocator locator, String ... expectedLocations) {
        for (String location : expectedLocations) {
            Assert.assertThat((String)String.format("%s is not initialized", location), (Object)locator.find(Location.builderFromStringRepresentation((String)location).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        }
    }

    private void assertLocationsNotInitialized(ConfigurationComponentLocator locator, String ... expectedLocations) {
        for (String location : expectedLocations) {
            Assert.assertThat((String)String.format("%s is initialized", location), (Object)locator.find(Location.builderFromStringRepresentation((String)location).build()), (Matcher)Matchers.is(Optional.empty()));
        }
    }

    private static ExtensionModel loadJavaSdkExtension(Class<?> extensionClass, ClassLoader classLoader, Set<ExtensionModel> dependencies) {
        ExtensionModelLoadingRequest loadingRequest = ExtensionModelLoadingRequest.builder((ClassLoader)classLoader, (DslResolvingContext)DslResolvingContext.getDefault(dependencies)).addParameter("type", (Object)extensionClass.getName()).addParameter("version", (Object)"1.0.0-SNAPSHOT").build();
        return new DefaultJavaExtensionModelLoader().loadExtensionModel(loadingRequest);
    }
}

