/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="ObjectStore Extension")
@Story(value="ObjectStore is used as an operation parameter")
public class ExtensionWithObjectStoreTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private ObjectStoreManager objectStoreManager;
    @Inject
    private org.mule.sdk.api.store.ObjectStoreManager sdkObjectStoreManager;

    protected String getConfigFile() {
        return "extension-with-objectstore-config.xml";
    }

    @Test
    @Description(value="Operation has a parameter which points to a globally defined object store")
    public void storeOnGlobalStore() throws Exception {
        this.assertStoreValue("storeMoneyOnGlobalStore", "bank", "money", 1234L);
    }

    @Test
    @Description(value="Operation has a parameter which points to a private ObjectStore defined inline")
    public void storeOnPrivateStore() throws Exception {
        this.assertStoreValue("storeMoneyOnPrivateStore", "burriedBarrel", "money", 1234L);
    }

    @Test
    @Description(value="Operation uses the Mule api Object Store Manager which is injected in the extension via @Inject annotation")
    public void storeUsingMuleObjectStoreManager() throws Exception {
        this.assertStoreValue("storeUsingMuleObjectStoreManager", "extensionObjectStore", "mule-money", 1500L);
    }

    @Test
    @Description(value="Operation uses the Sdk api Object Store Manager which is injected in the extension via @Inject annotation")
    public void storeUsingSdkObjectStoreManager() throws Exception {
        this.assertStoreValue("storeUsingSdkObjectStoreManager", "extensionObjectStore", "sdk-money", 2500L);
    }

    private void assertStoreValue(String flowName, String osName, String key, Long value) throws Exception {
        this.flowRunner(flowName).run();
        ObjectStore objectStore = this.objectStoreManager.getObjectStore(osName);
        MatcherAssert.assertThat((Object)((Long)objectStore.retrieve(key)), (Matcher)CoreMatchers.equalTo((Object)value));
    }
}

