/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

public class FlowConfigurationFunctionalTestCase
extends AbstractIntegrationTestCase {
    private static final String EXPECTED_ARRAY_IN_ARGS_RESULT = "testtestrecieved";
    @Inject
    private TestQueueManager queueManager;

    protected String getConfigFile() {
        return "org/mule/test/construct/flow.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
    }

    @Test
    public void testFlow() throws Exception {
        Flow flow = (Flow)this.registry.lookupByName("flow").get();
        Assert.assertEquals((long)5L, (long)flow.getProcessors().size());
        Assert.assertEquals((Object)"012xyzabc3", (Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("flow").withPayload((Object)"0")).run().getMessage()));
    }

    @Test
    public void testAsyncAsynchronous() throws Exception {
        ((FlowRunner)this.flowRunner("asynchronousAsync").withPayload((Object)"0")).run();
        Message message = this.queueManager.read("asynchronous-async-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)message, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        Thread thread = (Thread)message.getPayload().getValue();
        MatcherAssert.assertThat((Object)thread, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)thread);
    }

    @Test
    public void testInOutFlow() throws Exception {
        ((FlowRunner)this.flowRunner("inout").withPayload((Object)"0")).run();
        Assert.assertEquals((Object)"0", (Object)this.getPayloadAsString(this.queueManager.read("inout-out", 5000L, TimeUnit.MILLISECONDS).getMessage()));
    }

    @Test
    public void testInOutAppendFlow() throws Exception {
        ((FlowRunner)this.flowRunner("inout-append").withPayload((Object)"0")).run();
        Assert.assertEquals((Object)"0inout", (Object)this.getPayloadAsString(this.queueManager.read("inout-append-out", 5000L, TimeUnit.MILLISECONDS).getMessage()));
    }

    @Test
    public void testComponentsFlow() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("components").withPayload((Object)"0")).run().getMessage();
        MatcherAssert.assertThat((Object)result, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        Assert.assertNotSame((Object)"Test Messagetest", (Object)result.getPayload().getValue());
    }

    @Test
    public void testAsyncOneWayEndpoint() throws Exception {
        ((FlowRunner)this.flowRunner("async-oneway").withPayload((Object)"0")).run();
        Message result = this.queueManager.read("async-oneway-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Message asyncResult = this.queueManager.read("async-async-oneway-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)result, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)asyncResult, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        Assert.assertEquals((Object)"0ac", (Object)this.getPayloadAsString(result));
        Assert.assertEquals((Object)"0ab", (Object)this.getPayloadAsString(asyncResult));
    }

    @Test
    public void testAsyncRequestResponseEndpoint() throws Exception {
        CoreEvent syncResult = ((FlowRunner)this.flowRunner("async-requestresponse").withPayload((Object)"0")).run();
        Message result = this.queueManager.read("async-requestresponse-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Message asyncResult = this.queueManager.read("async-async-requestresponse-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        this.assertAsync(syncResult.getMessage(), result, asyncResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncTransactionalEndpoint() throws Exception {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction(transaction);
            return null;
        }).when((Object)transaction)).begin();
        try {
            CoreEvent syncResult = ((FlowRunner)this.flowRunner("async-tx").withPayload((Object)"0")).transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, transaction).run();
            Message result = this.queueManager.read("async-tx-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
            Message asyncResult = this.queueManager.read("async-async-tx-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
            this.assertAsync(syncResult.getMessage(), result, asyncResult);
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    private void assertAsync(Message syncResult, Message result, Message asyncResult) throws Exception {
        MatcherAssert.assertThat((Object)syncResult, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)result, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)asyncResult, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        Assert.assertEquals((Object)"0ac", (Object)this.getPayloadAsString(syncResult));
        Assert.assertEquals((Object)"0ac", (Object)this.getPayloadAsString(result));
        Assert.assertEquals((Object)"0ab", (Object)this.getPayloadAsString(asyncResult));
    }

    @Test
    public void testChoiceWithoutOutboundEndpoints() throws Exception {
        Assert.assertEquals((Object)"foo Hello foo", (Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("choice2").withPayload((Object)"foo")).run().getMessage()));
        Assert.assertEquals((Object)"bar Hello bar", (Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("choice2").withPayload((Object)"bar")).run().getMessage()));
        Assert.assertEquals((Object)"egh Hello ?", (Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("choice2").withPayload((Object)"egh")).run().getMessage()));
    }

    @Test
    public void testFlowRef() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("flow-ref").withPayload((Object)"0")).run().getMessage();
        Assert.assertEquals((Object)"012xyzabc312xyzabc3", (Object)this.getPayloadAsString(message));
    }

    @Test
    public void testLoggerMessage() throws Exception {
        ((FlowRunner)this.flowRunner("loggermessage").withPayload((Object)"0")).run();
    }

    @Test
    public void testLoggerHeader() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("loggerheader").withPayload((Object)"0")).withVariable("toLog", (Object)"valueToLog")).run();
    }

    @Test
    public void testPoll() throws Exception {
        Message message = this.queueManager.read("poll-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)message, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        Assert.assertEquals((Object)" Hello fooout", (Object)this.getPayloadAsString(message));
    }

    @Test
    public void testPollFlowRef() throws Exception {
        Message message = this.queueManager.read("poll2-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)message, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
        Assert.assertEquals((Object)"nullpollappendout", (Object)this.getPayloadAsString(message));
    }

    @Test
    public void testSubFlowMessageFilter() throws Exception {
        ((FlowRunner)this.flowRunner("messagefiltersubflow").withPayload((Object)"0")).run();
        Message message = this.queueManager.read("messagefiltersubflow-out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)message, (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
    }

    @Test
    public void customMaxConcurrency() throws Exception {
        Flow flow = (Flow)this.registry.lookupByName("customMaxConcurrency").get();
        MatcherAssert.assertThat((Object)flow.getMaxConcurrency(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    public static class ThreadSensingMessageProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            return CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).value((Object)Thread.currentThread()).build()).build();
        }
    }

    public static class Pojo {
        public void method() {
        }

        public void method(Object arg1, Object arg2) {
        }
    }
}

