/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Routers")
@Story(value="Until Successful")
@RunnerDelegateTo(value=Parameterized.class)
public class UntilSuccessfulPropagationTestCase
extends AbstractIntegrationTestCase {
    private final String flow;

    public UntilSuccessfulPropagationTestCase(String flow) {
        this.flow = flow;
    }

    protected String getConfigFile() {
        return "org/mule/test/routing/until-successful-propagation.xml";
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> data() {
        return Arrays.asList("variablePropagationToErrorHandler", "variablePropagationOutside", "variablePropagationWithoutError", "variableImmutableBetweenRetries", "payloadPropagation", "payloadPropagationWithoutError", "payloadImmutableBetweenRetries");
    }

    @Test
    public void runTest() throws Exception {
        this.assertPayloadContent(((FlowRunner)this.flowRunner(this.flow).withPayload((Object)"message")).run());
    }

    public void assertPayloadContent(CoreEvent event) {
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"message executed once"));
    }
}

