/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import org.apache.http.HttpResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.TlsTestUtils;
import org.mule.tls.fips.DefaultTestConfiguration;
import org.mule.tls.matcher.HttpResponseContentStringMatcher;
import org.mule.tls.matcher.HttpResponseStatusCodeMatcher;

@Feature(value="TLS/SSL")
public class TlsContextInsecureModeTestCase
extends AbstractIntegrationTestCase {
    @ClassRule
    public static final DynamicPort httpsPort = new DynamicPort("httpsPort");
    @ClassRule
    public static final DynamicPort httpsInternalInsecurePort = new DynamicPort("https.internal.insecure");
    @ClassRule
    public static final DynamicPort httpsInternalSecurePort = new DynamicPort("https.internal.secure");
    @ClassRule
    public static final DynamicPort httpsInternalSecureInvalidPort = new DynamicPort("https.internal.secure.invalid");
    @ClassRule
    public static final DynamicPort httpsInternalDefaultPort = new DynamicPort("https.internal.default");
    @ClassRule
    public static final DynamicPort httpsInternalDefaultInvalidPort = new DynamicPort("https.internal.default.invalid");
    @ClassRule
    public static final SystemProperty sslCacerts = new SystemProperty("sslCacerts", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslCaCerts());
    @ClassRule
    public static final SystemProperty sslKeyStore = new SystemProperty("sslKeyStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestSslKeyStore());
    @ClassRule
    public static final SystemProperty storeType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    @ClassRule
    public static final SystemProperty sslKeyStorePassword = new SystemProperty("sslKeyStorePassword", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().resolveStorePassword("changeit"));
    @ClassRule
    public static final SystemProperty sslCacertsPassword = new SystemProperty("sslCacertsPassword", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().resolveStorePassword("changeit"));
    @ClassRule
    public static final SystemProperty sslKeyStoreInvalid = new SystemProperty("sslKeyStoreInvalid", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getInvalidTestKeyStore());
    private static final String urlPrefix = "https://localhost:" + httpsPort.getValue();
    private static final String insecureModeUrl = urlPrefix + "/test/insecure";
    private static final String secureModeUrl = urlPrefix + "/test/securePass";
    private static final String secureModeInvalidUrl = urlPrefix + "/test/secureFails";
    private static final String defaultModeUrl = urlPrefix + "/test/defaultPass";
    private static final String defaultModeInvalidUrl = urlPrefix + "/test/defaultFails";
    private static final String OK_RESPONSE = "ok";

    protected String getConfigFile() {
        return "tls-insecure-config.xml";
    }

    @Test
    public void testGlobalTlsContextInsecureModeListener() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(insecureModeUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(200));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)CoreMatchers.is((Object)OK_RESPONSE)));
    }

    @Test
    public void testGlobalTlsContextSecureModeListener() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(secureModeUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(200));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)CoreMatchers.is((Object)OK_RESPONSE)));
    }

    @Test
    public void testGlobalTlsContextSecureModeInvalidListener() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(secureModeInvalidUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(500));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)Matchers.anyOf((Matcher)CoreMatchers.containsString((String)"General SSLEngine problem"), (Matcher)CoreMatchers.containsString((String)"No trusted certificate found"), (Matcher)CoreMatchers.containsString((String)"PKIX path building failed"), (Matcher)CoreMatchers.containsString((String)"certificate_unknown"))));
    }

    @Test
    public void testGlobalTlsContextDefaultModeListener() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(defaultModeUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(200));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)CoreMatchers.is((Object)OK_RESPONSE)));
    }

    @Test
    public void testGlobalTlsContextDefaultModeInvalidListener() throws Exception {
        HttpResponse response = TlsTestUtils.executeGetRequest(defaultModeInvalidUrl);
        MatcherAssert.assertThat((Object)response, HttpResponseStatusCodeMatcher.hasStatusCode(500));
        MatcherAssert.assertThat((Object)response, HttpResponseContentStringMatcher.body((Matcher<String>)Matchers.anyOf((Matcher)CoreMatchers.containsString((String)"General SSLEngine problem"), (Matcher)CoreMatchers.containsString((String)"No trusted certificate found"), (Matcher)CoreMatchers.containsString((String)"PKIX path building failed"), (Matcher)CoreMatchers.containsString((String)"certificate_unknown"))));
    }
}

