/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.lifecycle;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="Registry")
@Story(value="Object Registration")
public class ImplicitConfigurationLifeCycleTestCase
extends AbstractIntegrationTestCase {
    private Scheduler scheduler;
    private static Latch subflowIsInitializingLatch;
    private static Latch muleContextIsStoppingLatch;
    private static Latch eventHasBeenProcessedLatch;
    @Inject
    private TestQueueManager queueManager;
    private static final Logger LOGGER;

    @Before
    public void before() {
        subflowIsInitializingLatch = new Latch();
        muleContextIsStoppingLatch = new Latch();
        eventHasBeenProcessedLatch = new Latch();
        this.scheduler = muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withShutdownTimeout(10L, TimeUnit.SECONDS));
    }

    @After
    public void after() throws Exception {
        muleContext.dispose();
        this.scheduler.shutdown();
    }

    public String getConfigFile() {
        return "org/mule/test/integration/lifecycle/implicit-configuration-lifecycle.xml";
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    @Test
    @Issue(value="W-14722908")
    public void flowThatRegistersImplicitConfigurationDuringMuleContextStop() throws Exception {
        FlowRunner flowRunner = this.flowRunner("flowThatAddsRegistryEntryDuringFirstEventProcessing");
        flowRunner.dispatchAsync(this.scheduler);
        if (!subflowIsInitializingLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            LOGGER.warn("subflowIsInitializingLatch timed out.");
        }
        this.scheduler.submit(() -> {
            try {
                muleContext.stop();
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
        });
        CoreEvent errorResponse = this.queueManager.read("flowErrorQueue", 5000L, TimeUnit.MILLISECONDS);
        if (errorResponse == null) {
            Assert.fail((String)"Timeout while waiting for the event error response");
        }
        eventHasBeenProcessedLatch.release();
        Error processingError = (Error)errorResponse.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)processingError.getDescription(), (Matcher)CoreMatchers.is((Object)"Could not add entry with key 'implicit-config-implicit': Registry has been stopped."));
        MatcherAssert.assertThat((Object)processingError.getDetailedDescription(), (Matcher)CoreMatchers.is((Object)"Found exception while registering configuration provider 'implicit-config-implicit'"));
    }

    static {
        LOGGER = LoggerFactory.getLogger(ImplicitConfigurationLifeCycleTestCase.class);
    }

    public static class TriggerMuleContextStopWhileSubFlowIsBeingInitialized
    implements Processor,
    Initialisable {
        public CoreEvent process(CoreEvent event) throws MuleException {
            return event;
        }

        public void initialise() {
            subflowIsInitializingLatch.release();
            try {
                if (!muleContextIsStoppingLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("muleContextIsStoppingLatch timed out.");
                }
            }
            catch (InterruptedException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public static class SignalMuleContextIsStopping
    implements Processor,
    Stoppable {
        public CoreEvent process(CoreEvent event) throws MuleException {
            return event;
        }

        public void stop() throws MuleException {
            muleContextIsStoppingLatch.release();
            try {
                if (!eventHasBeenProcessedLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("eventHasBeenProcessedLatch timed out.");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

