/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.tls;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class TlsInsecureTrustStoreTestCase
extends AbstractIntegrationTestCase {
    private static final String EXPECTED_RESPONSE = "test";
    @Rule
    public DynamicPort portSsl = new DynamicPort("portSsl");

    protected String getConfigFile() {
        return "tls/tls-insecure-truststore-config.xml";
    }

    @Test
    public void whenUsingInsecureTrustStoreAndBothCertificatesAreUntrustedThenConnectionCanBeEstablished() throws Exception {
        CoreEvent response = this.flowRunner("flow-insecure-request").run();
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)EXPECTED_RESPONSE));
    }

    @Test
    @Issue(value="W-10822938")
    public void whenUsingInsecureTrustStoreWithoutClientCertificateThenConnectionCanBeEstablished() throws Exception {
        CoreEvent response = this.flowRunner("flow-insecure-request-no-client-cert").run();
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)EXPECTED_RESPONSE));
    }
}

