/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.TlsTestUtils;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
public class HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase
extends AbstractIntegrationTestCase {
    private static final String CLIENT_CIPHER_SUITE_ENABLED = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256";
    private static final String CLIENT_CIPHER_SUITE_DISABLED = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA";
    private static final String CLIENT_PROTOCOL_ENABLED = "TLSv1.2";
    private static final String CLIENT_PROTOCOL_DISABLED = "TLSv1";
    @Rule
    public SystemProperty serverKeyStoreType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    @Rule
    public SystemProperty trustStoreFile = new SystemProperty("trustStoreFile", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestGenericTrustKeyStore());
    @Rule
    public SystemProperty clientKeystoreFile = new SystemProperty("clientKeyStoreFile", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestClientKeyStore());
    @Rule
    public DynamicPort httpsPort = new DynamicPort("httpsPort");
    private String body;

    @BeforeClass
    public static void createTlsPropertiesFile() throws Exception {
        PrintWriter writer = new PrintWriter(HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase.getTlsPropertiesFile(), "UTF-8");
        writer.println("enabledCipherSuites=TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        writer.println("enabledProtocols=TLSv1.2");
        writer.close();
    }

    @AfterClass
    public static void removeTlsPropertiesFile() {
        HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase.getTlsPropertiesFile().delete();
    }

    private static File getTlsPropertiesFile() {
        return new File("tls-default.conf");
    }

    protected String getConfigFile() {
        return "http-request-restricted-protocols-ciphers-config.xml";
    }

    @Test
    public void handshakeSuccessWhenUsingEnabledCipherSpecAndProtocol() throws Exception {
        this.sendRequest(CLIENT_CIPHER_SUITE_DISABLED, CLIENT_PROTOCOL_DISABLED);
        MatcherAssert.assertThat((Object)this.body, (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
    }

    @Test
    public void handshakeFailsWithDisabledCipherSuite() throws Exception {
        this.assertFailure(CLIENT_CIPHER_SUITE_ENABLED, CLIENT_PROTOCOL_DISABLED);
    }

    @Test
    public void handshakeFailsWithDisabledProtocol() throws Exception {
        this.assertFailure(CLIENT_CIPHER_SUITE_DISABLED, CLIENT_PROTOCOL_ENABLED);
    }

    private void assertFailure(String serverCipherSuiteDisabled, String serverProtocolDisabled) {
        Exception thrown = (Exception)Assert.assertThrows(Exception.class, () -> this.sendRequest(serverCipherSuiteDisabled, serverProtocolDisabled));
        MatcherAssert.assertThat((Object)ExceptionHelper.getRootException((Throwable)thrown), (Matcher)Matchers.instanceOf(IOException.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(String serverCipherSuiteDisabled, String serverProtocolDisabled) throws Exception {
        Server server = this.createTlsServer(serverCipherSuiteDisabled, serverProtocolDisabled);
        server.start();
        try {
            ((FlowRunner)this.flowRunner("requestFlow").withPayload((Object)"Test Message")).run();
        }
        finally {
            server.stop();
        }
    }

    private Server createTlsServer(String disabledCipherSuite, String disabledProtocol) throws Exception {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(new File(TlsTestUtils.class.getClassLoader().getResource(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestServerKeyStore()).toURI()).getAbsolutePath());
        sslContextFactory.setKeyStoreType(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
        sslContextFactory.setKeyStorePassword("mulepassword");
        sslContextFactory.setKeyManagerPassword("mulepassword");
        sslContextFactory.addExcludeCipherSuites(new String[]{disabledCipherSuite});
        sslContextFactory.addExcludeProtocols(new String[]{disabledProtocol});
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, sslContextFactory);
        connector.setPort(this.httpsPort.getNumber());
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                HttpRequesterTlsRestrictedProtocolsAndCiphersTestCase.this.body = IOUtils.toString((InputStream)baseRequest.getInputStream(), (Charset)StandardCharsets.UTF_8);
                response.setContentType("text/html");
                response.setStatus(200);
                response.getWriter().print("Test Message");
                baseRequest.setHandled(true);
            }
        });
        return server;
    }
}

