/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.properties;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
@RunnerDelegateTo(value=Parameterized.class)
public class ReservedPropertyNamesTestCase
extends AbstractIntegrationTestCase {
    public static final String APP_NAME_PROPERTY = "app.name";
    public static final String APP_NAME = "my-app";
    public static final String TEST_PROPERTY_NAME = "key";
    public static final String OTHER_DEPLOYMENT_PROPERTY = "depprop";
    public static final String PROPERTY_VALUE = "custom-properties";
    public static final String CUSTOM_RESOLVER_PROPERTY = "secure::test.key1";
    public static final String CUSTOM_RESOLVER_PROPERTY_VALUE = "test.key1:value1:AES:CBC";
    @Inject
    private ConfigurationProperties configurationProperties;
    @Rule
    public SystemProperty systemProperty;
    private final String minMuleVersion;
    private final String expectedPropertyValue;

    @Parameterized.Parameters(name="With minMuleVersion {0} and override value \"{1}\"")
    public static Object[][] parameters() {
        return new Object[][]{{"4.1.5", "true", "value"}, {"4.2.2", "true", "value"}, {"4.3.0", "true", "value"}, {"4.1.5", null, "overridden.value"}, {"4.2.2", null, "overridden.value"}, {"4.3.0", null, "value"}, {"4.1.5", "false", "overridden.value"}, {"4.2.2", "false", "overridden.value"}, {"4.3.0", "false", "overridden.value"}};
    }

    public ReservedPropertyNamesTestCase(String minMuleVersion, String systemPropertyValue, String expectedPropertyValue) {
        this.minMuleVersion = minMuleVersion;
        this.expectedPropertyValue = expectedPropertyValue;
        if (systemPropertyValue != null) {
            this.systemProperty = new SystemProperty("mule.honour.reserved.properties", systemPropertyValue);
        }
    }

    @Test
    public void propertiesAreResolvedCorrectlyDependingOnVersionAndFeatureFlag() {
        Optional key = this.configurationProperties.resolveStringProperty(TEST_PROPERTY_NAME);
        MatcherAssert.assertThat((Object)key.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)key.get()), (Matcher)Is.is((Object)this.expectedPropertyValue));
    }

    @Test
    public void deploymentPropertiesArePartOfPropertiesResolution() {
        Optional key = this.configurationProperties.resolveStringProperty(OTHER_DEPLOYMENT_PROPERTY);
        MatcherAssert.assertThat((Object)key.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)key.get()), (Matcher)Is.is((Object)PROPERTY_VALUE));
    }

    @Test
    public void customPropertiesResolversCanDependOnDeploymentProperties() {
        Optional key = this.configurationProperties.resolveStringProperty(CUSTOM_RESOLVER_PROPERTY);
        MatcherAssert.assertThat((Object)key.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((String)key.get()), (Matcher)Is.is((Object)CUSTOM_RESOLVER_PROPERTY_VALUE));
    }

    protected String getConfigFile() {
        return "properties/reserved-property-names-config.xml";
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration muleConfiguration = super.createMuleConfiguration();
        if (this.minMuleVersion != null) {
            muleConfiguration.setMinMuleVersion(new MuleVersion(this.minMuleVersion));
        } else {
            muleConfiguration.setMinMuleVersion(null);
        }
        return muleConfiguration;
    }

    protected Map<String, String> artifactProperties() {
        return Map.of(APP_NAME_PROPERTY, APP_NAME, OTHER_DEPLOYMENT_PROPERTY, PROPERTY_VALUE);
    }
}

