/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.streaming;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Streaming")
@Story(value="Management of Streams")
public class TroubleshootClosedCursorProviderTestCase
extends AbstractIntegrationTestCase {
    private static final String FILE_NAME = "dummy.txt";
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty workingDirSysProp = new SystemProperty("workingDir", temporaryFolder.getRoot().getPath());
    @Rule
    public SystemProperty fileNameProp = new SystemProperty("fileName", "dummy.txt");
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/streaming/troubleshoot-cursor-provider-config.xml";
    }

    @Test
    public void trackCursorClosedOnOperation() throws Exception {
        this.expectedException.expect(MuleException.class);
        this.expectedException.expectCause(Matchers.isA(ExpressionRuntimeException.class));
        this.expectedException.expectMessage(Matchers.containsString((String)"The cursor provider was open by closeStreamOnOperationFlow/processors/0/processors/0."));
        FileUtils.writeStringToFile((File)new File(temporaryFolder.getRoot(), FILE_NAME), (String)"Hello", (Charset)Charset.defaultCharset());
        this.flowRunner("closeStreamOnOperationFlow").run();
    }

    @Test
    public void trackCursorClosedOnSource() throws IOException, TimeoutException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(String.format("http://localhost:%d/api/echo", this.port.getNumber())).entity((HttpEntity)new ByteArrayHttpEntity("Hello".getBytes()))).build();
        HttpRequestOptions options = HttpRequestOptions.builder().responseTimeout(5000).build();
        HttpResponse httpResponse = this.httpClient.send(httpRequest, options);
        String payload = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertThat((Object)payload, (Matcher)Matchers.containsString((String)"org.mule.runtime.core.internal.streaming.CursorProviderAlreadyClosedException"));
        Assert.assertThat((Object)payload, (Matcher)Matchers.containsString((String)"The cursor provider was open by closeStreamOnSourceFlow/source"));
    }

    public static class ClosePayloadProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            Object mcp = event.getMessage().getPayload().getValue();
            Assert.assertThat((Object)mcp, (Matcher)CoreMatchers.instanceOf(CursorProvider.class));
            ((CursorProvider)mcp).close();
            return event;
        }
    }
}

