/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.tls;

import io.qameta.allure.Issue;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import org.apache.activemq.broker.SslBrokerService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class TlsInsecureTrustStoreJmsTestCase
extends AbstractIntegrationTestCase {
    private static final String EXPECTED_RESPONSE = "Message received was: test";
    private static final String KEYSTORE_PATH = "test-classes/chain-cert-keystore.jks";
    private static final String KEYSTORE_PASS = "changeit";
    private static final String KEYSTORE_KEY_PASS = "changeit";
    private final SslBrokerService brokerService = new SslBrokerService();
    @Rule
    public DynamicPort portSsl = new DynamicPort("portSsl");

    protected String getConfigFile() {
        return "tls/tls-insecure-truststore-jms-config.xml";
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        super.doSetUpBeforeMuleContextCreation();
        this.brokerService.addSslConnector(String.format("ssl://localhost:%d", this.portSsl.getNumber()), this.getKeyManagerFactory().getKeyManagers(), null, null);
        this.brokerService.start();
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        this.brokerService.stop();
        super.doTearDownAfterMuleContextDispose();
    }

    @Test
    @Issue(value="W-12049036")
    public void whenUsingInsecureTrustStoreAndServerCertificateIsUntrustedThenConnectionCanBeEstablished() throws Exception {
        CoreEvent response = this.flowRunner("flow-publish-consume-insecure").run();
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)EXPECTED_RESPONSE));
    }

    private KeyManagerFactory getKeyManagerFactory() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        KeyStore ks = KeyStore.getInstance("JKS");
        try (FileInputStream ksIs = new FileInputStream(KEYSTORE_PATH);){
            ks.load(ksIs, "changeit".toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, "changeit".toCharArray());
        return kmf;
    }
}

