/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.component.EventCallback;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tests.api.TestQueueManager;

@RunnerDelegateTo(value=Parameterized.class)
public class RedeliveryPolicyTestCase
extends AbstractIntegrationTestCase {
    private static CountDownLatch latch;
    private static AtomicInteger awaiting;
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();
    @Inject
    private TestQueueManager queueManager;
    private final String processingStrategyFactoryClassname;

    @Parameterized.Parameters
    public static List<String> parameters() {
        return Arrays.asList("org.mule.runtime.core.internal.processor.strategy.TransactionAwareStreamEmitterProcessingStrategyFactory", "org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory");
    }

    public RedeliveryPolicyTestCase(String processingStrategyFactoryClassname) {
        this.processingStrategyFactoryClassname = processingStrategyFactoryClassname;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        super.doSetUpBeforeMuleContextCreation();
        this.setDefaultProcessingStrategyFactory(this.processingStrategyFactoryClassname);
    }

    @Before
    public void before() {
        latch = new CountDownLatch(1);
        awaiting.set(0);
    }

    @After
    public void after() throws Exception {
        latch.countDown();
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        super.doTearDownAfterMuleContextDispose();
        this.clearDefaultProcessingStrategyFactory();
    }

    protected String getConfigFile() {
        return "org/mule/test/components/redelivery-policy-config.xml";
    }

    @Test
    public void hashWorksOverDataWeaveObject() throws Exception {
        this.sendDataWeaveObjectMessageExpectingError("redeliveryPolicyFlowDispatch");
        this.sendDataWeaveObjectMessageExpectingError("redeliveryPolicyFlowDispatch");
        Assert.assertThat((Object)this.queueManager.read("redeliveredMessageQueue", 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void redeliveryPolicyDoesntUseCpuLite() throws Exception {
        Assume.assumeThat((Object)this.processingStrategyFactoryClassname, (Matcher)Matchers.is((Object)"org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory"));
        int dispatchs = Runtime.getRuntime().availableProcessors() * 2 + 1;
        for (int i = 0; i < dispatchs; ++i) {
            this.sendDataWeaveObjectMessage("redeliveryPolicyFlowLongDispatch");
        }
        PollingProber.probe((long)10000L, (long)100L, () -> {
            Assert.assertThat((Object)awaiting.get(), (Matcher)Matchers.is((Object)dispatchs));
            return true;
        });
    }

    @Test
    public void javaPojoPayload() throws Exception {
        PojoPayload pojoPayload = new PojoPayload();
        ((FlowRunner)((FlowRunner)this.flowRunner("redeliveryPolicy3FlowDispatch").withPayload((Object)pojoPayload)).withMediaType(MediaType.APPLICATION_JAVA)).run();
        Assert.assertThat((Object)this.queueManager.read("processed", 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)pojoPayload.isHashCodeCalled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Issue(value="MULE-19085")
    public void redeliveryPolicyAndErrorHandler() throws Exception {
        this.flowRunner("redeliveryPolicyAndErrorHandlerFlowDispatch").runExpectingException();
        Assert.assertThat((String)"Error handler was not called", (Object)this.queueManager.read("errorHandlerMessageQueue", 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
        Assert.assertThat((String)"Error handler was called more than once", (Object)this.queueManager.read("errorHandlerMessageQueue", 5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.nullValue());
    }

    @Test
    @Issue(value="MULE-19916")
    @Description(value="Test that when the evaluation of the message ID expression for the redelivery policy fails for a message from a source configured with transactions, the transaction is not rolled back by the source because of the flow finishing with an error.")
    public void redeliveryInvalidMessageIdWithTransactionalSourceAndCustomErrorHandler() throws Exception {
        this.flowRunner("redeliveryInvalidMessageIdWithTransactionalSourceAndCustomErrorHandlerDispatch").runExpectingException();
        this.assertExpressionErrorRaisedOnlyOnce("transactionalSourceCustomErrorHandlerMessageQueue");
    }

    @Test
    @Issue(value="MULE-19916")
    @Description(value="Test that when the evaluation of the message ID expression for the redelivery policy fails for a message from a source configured with transactions, the transaction is not rolled back by the error handler.")
    public void redeliveryInvalidMessageIdWithTransactionalSourceAndDefaultErrorHandler() throws Exception {
        this.flowRunner("redeliveryInvalidMessageIdWithTransactionalSourceAndDefaultErrorHandlerDispatch").runExpectingException();
        this.assertExpressionErrorRaisedOnlyOnce("expressionErrorDefaultErrorHandlerMessageQueue");
    }

    @Test
    @Issue(value="MULE-19916")
    @Description(value="Test that when the evaluation of the message ID expression for the redelivery policy fails, the flow finishes and a response is sent.")
    public void redeliveryInvalidMessageIdWithHttpListener() throws Exception {
        Assert.assertThat((Object)this.sendThroughHttp("invalidMessageId").getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        this.assertExpressionErrorRaisedOnlyOnce("expressionErrorDefaultErrorHandlerMessageQueue");
    }

    @Test
    @Issue(value="MULE-19921")
    @Description(value="Test that when the message ID of the redelivery policy is blank for a message from a source configured with transactions, the transaction is not rolled back by the source because of the flow finishing with an error.")
    public void redeliveryBlankMessageIdWithTransactionalSourceAndCustomErrorHandler() throws Exception {
        this.flowRunner("redeliveryBlankMessageIdWithTransactionalSourceAndCustomErrorHandlerDispatch").runExpectingException();
        this.assertExpressionErrorRaisedOnlyOnce("transactionalSourceCustomErrorHandlerMessageQueue");
    }

    @Test
    @Issue(value="MULE-19921")
    @Description(value="Test that when the message ID of the redelivery policy is blank for a message from a source configured with transactions, the transaction is not rolled back by the error handler.")
    public void redeliveryBlankMessageIdWithTransactionalSourceAndDefaultErrorHandler() throws Exception {
        this.flowRunner("redeliveryBlankMessageIdWithTransactionalSourceAndDefaultErrorHandlerDispatch").runExpectingException();
        this.assertExpressionErrorRaisedOnlyOnce("expressionErrorDefaultErrorHandlerMessageQueue");
    }

    private void assertExpressionErrorRaisedOnlyOnce(String queueName) {
        Assert.assertThat((String)"Message ID was not invalid", (Object)this.queueManager.read(queueName, 5000L, TimeUnit.MILLISECONDS), (Matcher)IsNull.notNullValue());
        Assert.assertThat((String)"Invalid message ID error thrown more than once", (Object)this.queueManager.read(queueName, 5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.nullValue());
    }

    private HttpResponse sendThroughHttp(String path) throws IOException, TimeoutException {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%s/%s", this.port.getNumber(), path)).method(HttpConstants.Method.POST).entity((HttpEntity)new ByteArrayHttpEntity("Test Message".getBytes()))).build();
        return this.httpClient.send(request, 5000, false, null);
    }

    private void sendDataWeaveObjectMessageExpectingError(String flowName) throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)"{ \"name\" : \"bruce\"}")).withMediaType(MediaType.APPLICATION_JSON)).runExpectingException();
    }

    private void sendDataWeaveObjectMessage(String flowName) throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)"{ \"name\" : \"bruce\"}")).withMediaType(MediaType.APPLICATION_JSON)).run();
    }

    static {
        awaiting = new AtomicInteger();
    }

    private static class PojoPayload {
        private boolean hashCodeCalled = false;

        private PojoPayload() {
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            this.hashCodeCalled = true;
            return super.hashCode();
        }

        public boolean isHashCodeCalled() {
            return this.hashCodeCalled;
        }
    }

    public static class LatchAwaitCallback
    extends AbstractComponent
    implements EventCallback {
        public void eventReceived(CoreEvent event, Object component, MuleContext muleContext) throws Exception {
            awaiting.incrementAndGet();
            latch.await();
        }
    }
}

