/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.http;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.tck.junit4.matcher.Eventually;
import org.mule.test.AbstractIntegrationTestCase;

@Issue(value="MULE-19774")
public class GrizzlyHttpClientSchedulerTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private HttpService httpService;
    @Inject
    private SchedulerService schedulerService;
    private Latch lockLatch;
    private Latch startTestLatch;
    private AtomicReference<Scheduler> schedulerReference;
    private HttpClient httpClient;
    private TestSchedulerService testSchedulerService;

    protected String getConfigFile() {
        return "org/mule/test/integration/http/dummy-app.xml";
    }

    @Before
    public void initialize() throws Exception {
        this.lockLatch = new Latch();
        this.startTestLatch = new Latch();
        this.schedulerReference = new AtomicReference();
        this.httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setName("http-client-scheduler").build());
        this.testSchedulerService = new TestSchedulerService(this.schedulerService){

            @Override
            public Scheduler customScheduler(SchedulerConfig config, int queueSize) {
                Scheduler scheduler = this.schedulerServiceDelegate.customScheduler(config, queueSize);
                GrizzlyHttpClientSchedulerTestCase.this.schedulerReference.set(scheduler);
                scheduler.execute(() -> {
                    try {
                        GrizzlyHttpClientSchedulerTestCase.this.startTestLatch.release();
                        GrizzlyHttpClientSchedulerTestCase.this.lockLatch.await();
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)"Fail initializing selector pool");
                    }
                });
                try {
                    GrizzlyHttpClientSchedulerTestCase.this.startTestLatch.await();
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
                return scheduler;
            }
        };
        Field schedulerServiceField = this.httpClient.getClass().getDeclaredField("schedulerService");
        this.setFinalField(this.httpClient, schedulerServiceField, this.testSchedulerService);
    }

    @Test
    @Description(value="Start the pool with an scheduler running a blocked task. The selector pool should success to start sending one task to the queue.")
    public void testSchedulerWithNonFinishTask() throws NoSuchFieldException, IllegalAccessException {
        Future future = this.schedulerService.customScheduler(SchedulerConfig.config().withDirectRunCpuLightWhenTargetBusy(true).withMaxConcurrentTasks(1).withName("TEST")).submit(() -> {
            this.httpClient.start();
            this.lockLatch.release();
        });
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getPrivateField(this.schedulerReference.get(), "executor");
        Assert.assertThat(executor.getQueue(), (Matcher)CoreMatchers.is((Matcher)Eventually.eventually((Matcher)Matchers.empty())));
    }

    private void setFinalField(Object object, Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(object, newValue);
    }

    private Object getPrivateField(Object obj, String field) throws NoSuchFieldException, IllegalAccessException {
        Field f = obj.getClass().getDeclaredField(field);
        f.setAccessible(true);
        return f.get(obj);
    }

    private static class TestSchedulerService
    implements SchedulerService {
        protected SchedulerService schedulerServiceDelegate;

        private TestSchedulerService(SchedulerService schedulerServiceDelegate) {
            this.schedulerServiceDelegate = schedulerServiceDelegate;
        }

        public String getName() {
            return this.schedulerServiceDelegate.getName();
        }

        public Scheduler cpuLightScheduler() {
            return this.schedulerServiceDelegate.cpuLightScheduler();
        }

        public Scheduler ioScheduler() {
            return this.schedulerServiceDelegate.ioScheduler();
        }

        public Scheduler cpuIntensiveScheduler() {
            return this.schedulerServiceDelegate.cpuIntensiveScheduler();
        }

        public Scheduler cpuLightScheduler(SchedulerConfig config) {
            return this.schedulerServiceDelegate.cpuLightScheduler(config);
        }

        public Scheduler ioScheduler(SchedulerConfig config) {
            return this.schedulerServiceDelegate.ioScheduler(config);
        }

        public Scheduler cpuIntensiveScheduler(SchedulerConfig config) {
            return this.schedulerServiceDelegate.cpuIntensiveScheduler(config);
        }

        public Scheduler cpuLightScheduler(SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
            return this.schedulerServiceDelegate.cpuLightScheduler(config, poolsConfigFactory);
        }

        public Scheduler ioScheduler(SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
            return this.schedulerServiceDelegate.ioScheduler(config, poolsConfigFactory);
        }

        public Scheduler cpuIntensiveScheduler(SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
            return this.schedulerServiceDelegate.cpuIntensiveScheduler(config, poolsConfigFactory);
        }

        public Scheduler customScheduler(SchedulerConfig config) {
            return this.schedulerServiceDelegate.customScheduler(config);
        }

        public Scheduler customScheduler(SchedulerConfig config, int queueSize) {
            return this.schedulerServiceDelegate.customScheduler(config, queueSize);
        }

        public List<SchedulerView> getSchedulers() {
            return this.schedulerServiceDelegate.getSchedulers();
        }
    }
}

