/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.TransactionNotification;
import org.mule.runtime.api.notification.TransactionNotificationListener;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class TransactionRollbackedByOwnerTestCase
extends AbstractIntegrationTestCase {
    private static final int POLL_DELAY_MILLIS = 100;
    private List<TransactionNotification> notifications;
    private final String flowName;
    private final String secondActionExpected;
    private final boolean throwsMessagingException;
    private final String config;
    @Rule
    public SystemProperty defaultErrorHandler = new SystemProperty("mule.enable.default.errorhandler.not.rollback.incorrect.tx", "true");

    @Parameterized.Parameters(name="{0} - {2}")
    public static Object[][] params() {
        return new Object[][]{{"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback", false, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "rollback", true, "rollback"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-outside-try", true, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-flowref", false, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref", false, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "rollback-error-in-flow-ref-with-try", true, "rollback"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref-with-try", false, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref-with-try-join-tx", false, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-implicit-default-EH-executed-commits", false, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-implicit-default-EH-executed-rollback", true, "rollback"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-on-error-prop", false, "rollback"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-default-on-error-prop", true, "rollback"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-in-flow", true, "rollback"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-flow-on-error-continue", false, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-nested-subflows", true, "rollback"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-nested-subflows", false, "commit"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-nested-flows", true, "rollback"}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-nested-flows", false, "commit"}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback", false, "commit"}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback", false, "rollback"}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-outside-try", true, "commit"}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-flowref", false, "commit"}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flow-ref", false, "commit"}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-flow-ref-with-try", true, "rollback"}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flow-ref-with-try", false, "commit"}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flow-ref-with-try-join-tx", false, "commit"}};
    }

    public TransactionRollbackedByOwnerTestCase(String type, String config, String flowName, boolean throwsMessagingException, String secondNotification) {
        this.flowName = flowName;
        this.secondActionExpected = secondNotification;
        this.throwsMessagingException = throwsMessagingException;
        this.config = config;
    }

    protected String getConfigFile() {
        return this.config;
    }

    protected void doSetUp() throws Exception {
        this.notifications = new ArrayList<TransactionNotification>();
    }

    @Test
    public void checkRollback() throws Exception {
        block3: {
            TransactionNotificationListener listener = notification -> this.notifications.add((TransactionNotification)notification);
            muleContext.getNotificationManager().addListener((NotificationListener)listener);
            try {
                ((FlowRunner)this.flowRunner(this.flowName).withPayload((Object)"message")).run();
                if (this.throwsMessagingException) {
                    Assert.fail((String)"Should have thrown Exception from unhandled error");
                }
            }
            catch (Exception e) {
                if (this.throwsMessagingException) break block3;
                Assert.fail((String)"Should have not thrown Exception from handled error");
            }
        }
        this.assertNotificationsArrived();
        this.assertCorrectNotifications();
    }

    private void assertNotificationsArrived() {
        PollingProber pollingProber = new PollingProber(5000L, 100L);
        pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                Assert.assertThat((Object)TransactionRollbackedByOwnerTestCase.this.notifications.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                return true;
            }

            public String describeFailure() {
                return "Notifications did not arrive";
            }
        });
    }

    private void assertCorrectNotifications() {
        Assert.assertThat((Object)this.notifications.get(0).getActionName(), (Matcher)CoreMatchers.is((Object)"begin"));
        Assert.assertThat((Object)this.notifications.get(1).getActionName(), (Matcher)CoreMatchers.is((Object)this.secondActionExpected));
    }
}

