/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.context.notification;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runners.Parameterized;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class NotificationTypesTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedException expected;
    private String configFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"org/mule/test/context/notification/mule-config-inexistent-notification.xml", expected -> expected.expectMessage(Matchers.containsString((String)"No notification 'nothing:I-DONT-EXIST' declared in this applications plugins to enable."))}, {"org/mule/test/context/notification/mule-config-disable-inexistent-notification.xml", expected -> expected.expectMessage(Matchers.containsString((String)"No notification 'nothing:I-DONT-EXIST' declared in this applications plugins to disable."))}, {"org/mule/test/context/notification/mule-config-invalid-notification.xml", expected -> expected.expectMessage(Matchers.containsString((String)"'1234' is not a valid value of union type 'notificationTypes'"))}, {"org/mule/test/context/notification/mule-config-disable-invalid-notification.xml", expected -> expected.expectMessage(Matchers.containsString((String)"'1234' is not a valid value of union type 'notificationTypes'"))});
    }

    public NotificationTypesTestCase(String configFile, Consumer<ExpectedException> expectedConfigurer) {
        this.configFile = configFile;
        this.expected = ExpectedException.none();
        expectedConfigurer.accept(this.expected);
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Test
    public void failingNotificationType() {
    }
}

