/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.properties;

import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties resolver story")
@RunnerDelegateTo(value=Parameterized.class)
public class ReservedPropertyNamesTestCase
extends AbstractIntegrationTestCase {
    public static final String APP_NAME_PROPERTY = "app.name";
    public static final String APP_NAME = "my-app";
    public static final String TEST_PROPERTY_NAME = "key";
    @Inject
    private ConfigurationProperties configurationProperties;
    @Rule
    public SystemProperty systemProperty;
    private final String minMuleVersion;
    private final String expectedPropertyValue;

    @Parameterized.Parameters(name="With minMuleVersion {0} and override value \"{1}\"")
    public static Object[][] parameters() {
        return new Object[][]{{"4.1.5", "true", "value"}, {"4.2.2", "true", "value"}, {"4.3.0", "true", "value"}, {"4.1.5", null, "overridden.value"}, {"4.2.2", null, "overridden.value"}, {"4.3.0", null, "value"}, {"4.1.5", "false", "overridden.value"}, {"4.2.2", "false", "overridden.value"}, {"4.3.0", "false", "overridden.value"}};
    }

    public ReservedPropertyNamesTestCase(String minMuleVersion, String systemPropertyValue, String expectedPropertyValue) {
        this.minMuleVersion = minMuleVersion;
        this.expectedPropertyValue = expectedPropertyValue;
        if (systemPropertyValue != null) {
            this.systemProperty = new SystemProperty("mule.honour.reserved.properties", systemPropertyValue);
        }
    }

    @Test
    public void propertiesAreResolvedCorrectly() {
        Optional key = this.configurationProperties.resolveStringProperty(TEST_PROPERTY_NAME);
        Assert.assertThat((Object)key.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(key.get(), (Matcher)Is.is((Object)this.expectedPropertyValue));
    }

    protected String getConfigFile() {
        return "properties/reserved-property-names-config.xml";
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration muleConfiguration = super.createMuleConfiguration();
        if (this.minMuleVersion != null) {
            muleConfiguration.setMinMuleVersion(new MuleVersion(this.minMuleVersion));
        }
        return muleConfiguration;
    }

    protected Map<String, String> artifactProperties() {
        return ImmutableMap.builder().put((Object)APP_NAME_PROPERTY, (Object)APP_NAME).build();
    }
}

