/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Issue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;

@Issue(value="MULE-16892")
public class ErrorHandlingWithFlowRefTestCase
extends AbstractIntegrationTestCase {
    private static int executions;

    @Before
    public void resetExecutions() {
        executions = 0;
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/error-handler-flow-ref.xml";
    }

    @Test
    public void errorHandlerExecutedOnceWithAllStaticFlowRef() throws Exception {
        this.flowRunner("error-handler-with-flow-ref-all-static").run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithDynamicFlowRef() throws Exception {
        ((FlowRunner)this.flowRunner("error-handler-with-flow-ref-dynamic").withVariable("flowToExecute", (Object)"flow-modif")).run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithDynamicErrorFlowRef() throws Exception {
        ((FlowRunner)this.flowRunner("error-handler-with-flow-ref-error-dynamic").withVariable("errorFlowToExecute", (Object)"flow-with-error")).run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithAllDynamicFlowRef() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("error-handler-with-flow-ref-error-dynamic").withVariable("errorFlowToExecute", (Object)"flow-with-error")).withVariable("flowToExecute", (Object)"flow-modif")).run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithAllStaticFlowRefSubFlow() throws Exception {
        this.flowRunner("error-handler-with-flow-ref-to-sub-flow").run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithAllStaticFlowRefAllSubFlow() throws Exception {
        this.flowRunner("error-handler-with-flow-ref-all-sub-flow").run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithAllStaticFlowRefErrorSubFlow() throws Exception {
        this.flowRunner("error-handler-with-flow-ref-to-error-sub-flow").run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithDynamicSubFlowRef() throws Exception {
        ((FlowRunner)this.flowRunner("error-handler-with-flow-ref-dynamic").withVariable("flowToExecute", (Object)"sub-flow-modif")).run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithDynamicErrorSubFlowRef() throws Exception {
        ((FlowRunner)this.flowRunner("error-handler-with-flow-ref-error-dynamic").withVariable("errorFlowToExecute", (Object)"sub-flow-with-error")).run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void errorHandlerExecutedOnceWithAllDynamicSubFlowRef() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("error-handler-with-flow-ref-error-dynamic").withVariable("errorFlowToExecute", (Object)"sub-flow-with-error")).withVariable("flowToExecute", (Object)"sub-flow-modif")).run();
        MatcherAssert.assertThat((Object)executions, (Matcher)CoreMatchers.is((Object)1));
    }

    public static class TestProcessorCounter
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            executions++;
            return event;
        }
    }
}

