/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.streaming;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Streaming")
public class NullParametersTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/streaming/null-parameters-config.xml";
    }

    @Test
    public void nullOperationParam() throws Exception {
        this.flowRunner("operationExplicit").run();
    }

    @Test
    public void varNotExistsOperationParam() throws Exception {
        this.flowRunner("operationVar").run();
    }

    @Test
    @Issue(value="MULE-18876")
    public void nullSourceResponseParam() throws IOException, TimeoutException {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri("http://localhost:" + this.port.getNumber() + "/testExplicit").method(HttpConstants.Method.GET).entity((HttpEntity)new ByteArrayHttpEntity("test".getBytes()))).build();
        HttpResponse response = this.httpClient.send(request, 60, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    @Issue(value="MULE-18876")
    public void varNotExistsSourceResponseParam() throws IOException, TimeoutException {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri("http://localhost:" + this.port.getNumber() + "/testVar").method(HttpConstants.Method.GET).entity((HttpEntity)new ByteArrayHttpEntity("test".getBytes()))).build();
        HttpResponse response = this.httpClient.send(request, 60, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }
}

